/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.rules.proxy;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.rules.PGParametersPropertiesProvider;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PGParametersProperties
implements PGParametersPropertiesProvider {
    private String pgName;
    private String gdsName;
    private String paymentType;

    public PGParametersProperties(PgName pgName, GdsName gdsName, PaymentType paymentType) {
        if (Objects.nonNull(pgName)) {
            this.pgName = pgName.name();
        }
        if (Objects.nonNull(gdsName)) {
            this.gdsName = gdsName.name();
        }
        if (Objects.nonNull(paymentType)) {
            this.paymentType = paymentType.name();
        }
    }

    public static PGParametersProperties newInstance(PgName pgName, BookingFile bookingFile, PaymentType paymentType) {
        GdsName gdsName = null;
        if (Objects.nonNull(bookingFile)) {
            gdsName = BookingStreamHelper.getProductsStream((BookingFile)bookingFile, Product.class).map(BaseProduct::getReservation).map(CommonReservationGdsNameInfoHelper::getDisplayedGdsName).filter(Objects::nonNull).findAny().orElse(null);
            List reservations = bookingFile.getReservations();
            if (Objects.isNull(gdsName) && reservations.size() == 1) {
                gdsName = CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)((Reservation)CollectionUtil.head((Iterable)reservations)));
            }
        }
        return new PGParametersProperties(pgName, gdsName, paymentType);
    }

    public static PGParametersProperties newInstance(PgName pgName, Payment payment) {
        Optional<Payment> paymentOptional = Optional.ofNullable(payment);
        PaymentType paymentType = paymentOptional.map(Payment::getPaymentType).orElse(null);
        BookingFile bookingFile = paymentOptional.map(Payment::getEntity).map(EntityStorageHelper::resolve).map(EntityContainer::getEntity).filter(BookingFile.class::isInstance).map(BookingFile.class::cast).orElse(null);
        return PGParametersProperties.newInstance(pgName, bookingFile, paymentType);
    }

    public String getPgName() {
        return this.pgName;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public void setPaymentType(String value) {
        this.paymentType = value;
    }

    public void setPg(String value) {
        this.pgName = value;
    }

    public void setGds(String value) {
        this.gdsName = value;
    }

    public String getPaymentType() {
        return this.paymentType;
    }
}

