/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.split;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PgSabreSessionManager {
    private static final Logger log = Logger.getLogger(PgSabreSessionManager.class);
    private static final Map<String, SabreSession> sessions = Collections.synchronizedMap(new HashMap());

    public static SabreSession createSession(EntityContainer<BookingFile> bookingFile) {
        try {
            if (sessions.containsKey(((BookingFile)bookingFile.getEntity()).getNumber())) {
                PgSabreSessionManager.releaseSession(bookingFile);
            }
            Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
            SalesContext salesContext = GDSHelper.createSalesContext((Reservation)baseProductReservation);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFile);
            data.put(IBusMidofficeContextKeys.RESERVATION_UID.name(), baseProductReservation.getUid());
            data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
            IntegrationBusFacade.get().getRequestReplyAdapter("pg:create-sabre-session").processSync(data);
            SabreSession session = (SabreSession)data.get("SABRE_SESSION");
            sessions.put(((BookingFile)bookingFile.getEntity()).getNumber(), session);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Allocate sabre session [%s], bookingFile [%s]", session.getConversationId(), ((BookingFile)bookingFile.getEntity()).getNumber()));
            }
            return session;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static void releaseSession(EntityContainer<BookingFile> bookingFile) throws Exception {
        SabreSession sabreSession = sessions.get(((BookingFile)bookingFile.getEntity()).getNumber());
        if (sabreSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Release sabre session [%s], paymentId [%s]", sabreSession.getConversationId(), ((BookingFile)bookingFile.getEntity()).getNumber()));
            }
            Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
            try {
                SalesContext salesContext = GDSHelper.createSalesContext((Reservation)baseProductReservation);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFile);
                data.put(IBusMidofficeContextKeys.RESERVATION_UID.name(), baseProductReservation.getUid());
                data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
                data.put("SABRE_SESSION", sabreSession);
                IntegrationBusFacade.get().getRequestReplyAdapter("pg:close-sabre-session").processSync(data);
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
            }
            sessions.remove(((BookingFile)bookingFile.getEntity()).getNumber());
        }
    }
}

