/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.split;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitPaymentHelper {
    private static final transient Logger log = LoggerFactory.getLogger(SplitPaymentHelper.class);

    public static BigDecimal getSplitPaymentCommisionPartAmount(BookingFile bookingFile, BigDecimal orderPrice) {
        return SplitPaymentHelper.getSplitPaymentCommisionPartAmount(bookingFile.getReservations(), orderPrice);
    }

    public static BigDecimal getSplitPaymentCommisionPartAmount(Collection<Reservation> reservations, BigDecimal orderPrice) {
        BigDecimal sabrePrice = BigDecimal.ZERO;
        Set<GdsName> gdsSupportingSplitPayments = PaymentHelper.getGdsSupportingSplitPayments();
        for (Reservation res : reservations) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof Product)) continue;
                Product product = (Product)prod;
                if (!gdsSupportingSplitPayments.contains(CommonReservationGdsNameInfoHelper.getDisplayedGdsName((Reservation)res))) continue;
                sabrePrice = sabrePrice.add(AirProductHelper.getEquivalentFare((Product)product));
                BigDecimal taxesEquivalentAmount = AirProductHelper.calculateTaxesEquivalentAmount((Product)product);
                if (taxesEquivalentAmount == null) continue;
                sabrePrice = sabrePrice.add(taxesEquivalentAmount);
            }
        }
        return orderPrice.subtract(sabrePrice);
    }

    public static String buildAcceptableCardValue(Payment payment, Map<CardVendor, String> paymentgateCardVendorsMap) {
        BookingFile bookingFile = (BookingFile)SplitPaymentHelper.getBookingFileContainer(payment).getEntity();
        Set<AirlineCard> acceptableCards = PaymentHelper.getAcceptedCards(bookingFile);
        StringBuilder cardsParameter = new StringBuilder();
        for (AirlineCard airlineCard : acceptableCards) {
            String code = airlineCard.getCode();
            CardVendor vendor = airlineCard.getVendor();
            if (vendor == null || TextUtil.isBlank((String)code)) continue;
            String unitellerVendorCode = paymentgateCardVendorsMap.get(vendor);
            String unitellerCardCode = code;
            if (cardsParameter.length() > 0) {
                cardsParameter.append(";");
            }
            cardsParameter.append(unitellerVendorCode).append(":").append(unitellerCardCode);
        }
        return cardsParameter.toString();
    }

    public static String getGdsApprovalCode(EntityReference<BookingFile> bookingFileRef) {
        try {
            EntityContainer bfCtr = EntityStorage.get().resolve(bookingFileRef);
            Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bfCtr.getEntity()));
            SalesContext salesContext = GDSHelper.createSalesContext((Reservation)baseProductReservation);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bfCtr);
            data.put(IBusMidofficeContextKeys.RESERVATION_UID.name(), baseProductReservation.getUid());
            data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
            IntegrationBusFacade.get().getRequestReplyAdapter("pg:get-pnr-split-approval-code").processSync(data);
            String approvalCode = (String)data.get("APPROVAL_CODE");
            if (log.isDebugEnabled()) {
                log.debug(String.format("[%s] found approval code in sabre pnr", ((BookingFile)bfCtr.getEntity()).getNumber()));
            }
            return approvalCode;
        }
        catch (Exception e) {
            SplitPaymentHelper.auditMessage(bookingFileRef, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"approval code isn't found", (Object[])new Object[0]));
            log.error("", (Throwable)e);
            return "";
        }
    }

    private static void auditMessage(EntityReference<BookingFile> entityReference, Message message) {
        SysLogHelper.audit(entityReference, (String)"split-payment", (Message[])new Message[]{message});
    }

    public static Optional<String> getApprovalCodeRemark(BookingFile bookingFile) {
        Reservation reservation = BookingHelper.getBaseProductReservation((BookingFile)bookingFile, (boolean)true);
        return Optional.ofNullable(reservation.getAdditionalInfo().getPaymentApprovalCode());
    }

    public static void saveApprovalCodeRemark(EntityContainer<BookingFile> bookingFile, String approvalCode) {
        SplitPaymentHelper.saveApprovalCodeRemark(bookingFile, null, approvalCode);
    }

    public static void saveApprovalCodeRemark(EntityContainer<BookingFile> bookingFile, Payment payment, String approvalCode) {
        Collection<Reservation> reservations;
        Collection<Reservation> collection = reservations = payment != null ? PaymentHelper.getReservations(bookingFile, (Collection<String>)payment.getReservations()) : null;
        if (reservations != null) {
            reservations.forEach(r -> r.getAdditionalInfo().setPaymentApprovalCode(approvalCode));
        } else {
            Reservation aviaReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
            aviaReservation.getAdditionalInfo().setPaymentApprovalCode(approvalCode);
        }
        bookingFile.getVersionInfo().setVersionNotes("save-approval-code");
        bookingFile.getVersionInfo().setDataSource("split-helper");
        EntityStorage.get().save(bookingFile, true);
    }

    private static EntityContainer<BookingFile> getBookingFileContainer(Payment payment) {
        EntityContainer bfCtr = EntityStorage.get().resolve(payment.getEntity());
        return bfCtr;
    }
}

