/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.split.ibus;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.RemarkLinePNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkPNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarksPNRB;
import com.sabre.webservices.pnrbuilder.v119.ReservationPNRB;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FindPaymentApprovalCodeProcessor
extends BaseProcessor {
    private final Pattern pattern = Pattern.compile("^X\\*FOP\\sCC.*\\*(\\d{6})$");

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        int count = 0;
        String approvalCode = null;
        List remarks = Optional.ofNullable(response.getReservation()).map(ReservationPNRB::getRemarks).map(RemarksPNRB::getRemarkList).orElse(Collections.emptyList());
        for (RemarkPNRB remark : remarks) {
            String remartText = remark.getRemarkLines().getRemarkLineList().stream().map(RemarkLinePNRB::getText).collect(Collectors.joining());
            Matcher m = this.pattern.matcher(remartText);
            if (!m.find()) continue;
            approvalCode = m.group(1);
            ++count;
        }
        if (count == 0) {
            throw Xeption.forDeveloper((String)"Approval code isn't found", (Object[])new Object[0]);
        }
        if (count > 1) {
            throw Xeption.forDeveloper((String)"Found more than one approval code values", (Object[])new Object[0]);
        }
        ctx.putObject("APPROVAL_CODE", approvalCode);
    }
}

