/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.storage;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.util.LogUtil;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheck;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheckIndex;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.pg.helper.PgPaymentCheckHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgPaymentCheckContainerInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PgPaymentCheckContainerInterceptor.class);
    public static final double PRIORITY = 1.0;

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!PgPaymentCheck.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        PgPaymentCheck newCheck = (PgPaymentCheck)data.getEntity();
        String paymentId = newCheck.getPaymentId();
        SearchResult<PgPaymentCheckIndex> existingChecks = PgPaymentCheckHelper.findPgPaymentChecks(paymentId, 1);
        existingChecks.getData().removeIf(idx -> MiscUtil.equals((Object)idx.getSource(), (Object)data.toReference()));
        if (existingChecks.getData().size() > 0) {
            PgPaymentCheckIndex idx2 = (PgPaymentCheckIndex)existingChecks.getData().get(0);
            IncidentsLog.reportStackTrace((String)String.format("%s with paymentId=%s already exists (uid=%s)", PgPaymentCheck.class.getSimpleName(), paymentId, idx2.getSource().getUid()));
        } else if (log.isInfoEnabled()) {
            String message = LogUtil.getStackTrace((String)String.format("creating %s for paymentId=%s", PgPaymentCheck.class.getSimpleName(), paymentId));
            log.info(message);
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    public double getPriority() {
        return 1.0;
    }
}

