/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.trace;

import com.gridnine.xtrip.server.pg.trace.StepItem;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

@XStreamAlias(value="http-request")
public class HttpRequestItem
extends StepItem {
    private String requestMethod;
    private String remoteAddress;
    private List<Header> headers = new ArrayList<Header>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private String body;

    public HttpRequestItem(HttpServletRequest request) {
        this.requestMethod = request.getMethod();
        this.remoteAddress = request.getRemoteAddr();
        this.addHeaders(request);
        this.addParams(request);
    }

    private void addParams(HttpServletRequest request) {
        for (Map.Entry param : request.getParameterMap().entrySet()) {
            this.parameters.add(new Parameter((String)param.getKey(), ((String[])param.getValue())[0]));
        }
    }

    private void addHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            this.headers.add(this.createHeader(request, headerName));
        }
    }

    private Header createHeader(HttpServletRequest request, String headerName) {
        String value = request.getHeader(headerName);
        return new Header(headerName, this.maskHeader(headerName, value));
    }

    private String maskHeader(String headerName, String value) {
        if ("authorization".equals(headerName)) {
            value = value.replaceAll(" .*", " ---masked---");
        }
        return value;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @XStreamAlias(value="parameter")
    private static class Parameter {
        @XStreamAsAttribute
        private String name;
        private String value;

        public Parameter(String name, String password) {
            this.name = name;
            this.value = password;
        }
    }

    @XStreamAlias(value="header")
    private static class Header {
        @XStreamAsAttribute
        private String name;
        private String value;

        public Header(String name, String password) {
            this.name = name;
            this.value = password;
        }
    }
}

