/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.trace;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.pg.trace.ExceptionItem;
import com.gridnine.xtrip.server.pg.trace.HttpRequestItem;
import com.gridnine.xtrip.server.pg.trace.ServletResponseItem;
import com.gridnine.xtrip.server.pg.trace.SimpleItem;
import com.gridnine.xtrip.server.pg.trace.StepItem;
import com.gridnine.xtrip.server.pg.trace.XSeriazibleItem;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="steps")
public class TraceLog {
    @XStreamOmitField
    private String operation;
    @XStreamImplicit
    private List<StepItem> steps = new ArrayList<StepItem>();

    public TraceLog(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void addStep(StepItem item) {
        this.steps.add(item);
    }

    public List<StepItem> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public String toXml() {
        for (int index = 0; index < this.steps.size(); ++index) {
            this.steps.get(index).setIndex(index);
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out){
                    boolean cdata;
                    {
                        this.cdata = false;
                    }

                    public void startNode(String name, Class clazz) {
                        super.startNode(name, clazz);
                        this.cdata = name.equals("content") || name.startsWith("stacktrace");
                    }

                    protected void writeText(QuickWriter writer, String text) {
                        if (this.cdata) {
                            writer.write("<![CDATA[");
                            writer.write(text);
                            writer.write("]]>");
                        } else {
                            writer.write(text);
                        }
                    }
                };
            }
        });
        xstream.ignoreUnknownElements();
        xstream.processAnnotations(TraceLog.class);
        xstream.processAnnotations(SimpleItem.class);
        xstream.processAnnotations(XSeriazibleItem.class);
        xstream.processAnnotations(HttpRequestItem.class);
        xstream.processAnnotations(ServletResponseItem.class);
        xstream.processAnnotations(ExceptionItem.class);
        String xml = xstream.toXML((Object)this);
        return xml;
    }

    public TraceItem toTraceItem() {
        return new TraceItem(){

            public String getId() {
                return String.format("%s-%s.xml", TraceLog.this.operation, MiscUtil.getTimestamp());
            }

            public void write(OutputStream strm) throws IOException {
                strm.write(TraceLog.this.toXml().getBytes());
            }
        };
    }
}

