/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.v2;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.server.pg.v2.PaymentServiceSettingsProvider;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class PaymentServiceHelper {
    PaymentServiceHelper() {
    }

    static void updateFops(BookingFile bf, PaymentType paymentType) throws Exception {
        PaymentServiceSettingsProvider provider = (PaymentServiceSettingsProvider)Environment.getPublished(PaymentServiceSettingsProvider.class);
        EntityReference agent = ((Reservation)bf.getReservations().get(0)).getBookingAgent();
        BigDecimal amount = BookingHelper.getTotalPrice((BookingFile)bf, (ContractType)provider.getPayerContractType(bf, paymentType));
        GeneralProductFop fop = new GeneralProductFop();
        fop.setAgent(agent);
        fop.setEquivalentAmount(amount);
        fop.setOperationDate(new Date());
        fop.setType(provider.getVendorPaymentType(paymentType));
        List<GeneralProductFop> vendorFops = Collections.singletonList(fop);
        GeneralProductFop fop2 = new GeneralProductFop();
        fop2.setAgent(agent);
        fop2.setEquivalentAmount(amount);
        fop2.setOperationDate(new Date());
        fop2.setType(provider.getSubagencyPaymentType(paymentType));
        List<GeneralProductFop> subagentFops = Collections.singletonList(fop2);
        GeneralProductFop fop3 = new GeneralProductFop();
        fop3.setAgent(agent);
        fop3.setEquivalentAmount(amount);
        fop3.setOperationDate(new Date());
        fop3.setType(provider.getClientPaymentType(paymentType));
        List<GeneralProductFop> clientFops = Collections.singletonList(fop3);
        for (Reservation res : bf.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                GeneralProductHelper.updateFops((BaseProduct)bp, (ContractType)ContractType.VENDOR, vendorFops);
                GeneralProductHelper.updateFops((BaseProduct)bp, (ContractType)ContractType.SUBAGENCY, subagentFops);
                GeneralProductHelper.updateFops((BaseProduct)bp, (ContractType)ContractType.CLIENT, clientFops);
            }
        }
    }

    static Reservation addFakeDelivery(EntityContainer<BookingFile> bfCtr, ContractType contractType) {
        DeliveryContext context = PaymentServiceHelper.getDeliveryContext((BookingFile)bfCtr.getEntity());
        Reservation deliveryRes = new Reservation();
        ((BookingFile)bfCtr.getEntity()).getReservations().add(deliveryRes);
        deliveryRes.setBookingFile((BookingFile)bfCtr.getEntity());
        deliveryRes.getGdsNameInfo().setRulesGdsName(GdsName.WEB_SITE);
        Delivery delivery = new Delivery();
        delivery.setReservation(deliveryRes);
        deliveryRes.getProducts().add(delivery);
        delivery.setAgency(context.agency);
        delivery.setAgent(context.agent);
        delivery.setIssueDate(context.issueDate);
        delivery.setReservation(deliveryRes);
        delivery.setSalesPoint(context.salesPoint);
        delivery.setStatus(DeliveryStatus.PLANNED);
        for (Reservation res : ((BookingFile)bfCtr.getEntity()).getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                VatAmount productPrice;
                DeliveryItem item = new DeliveryItem();
                item.setProductUid(bp.getUid());
                item.setBooking(bfCtr.toReference());
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                Fop fop = GeneralProductHelper.findFop((BaseProduct)bp);
                item.setPaymentType(fop == null ? PaymentType.CASH : fop.getType());
                item.setName(handler.generateShortProductName(bp));
                BigDecimal cost = GeneralProductHelper.calculateFee((BaseProduct)bp, (ContractType)contractType);
                if (cost == null) {
                    cost = BigDecimal.ZERO;
                }
                if ((productPrice = handler.calculateProductPrice(bp, ContractType.CLIENT)) != null) {
                    cost = cost.add(productPrice.getTotal());
                }
                item.setCost(cost);
                delivery.getDeliveryItems().add(item);
            }
        }
        return deliveryRes;
    }

    private static DeliveryContext getDeliveryContext(BookingFile bf) {
        DeliveryContext result = new DeliveryContext();
        for (Reservation res : bf.getReservations()) {
            for (BaseProduct bp : res.getProducts()) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                if (result.agency == null) {
                    result.agency = GeneralProductHelper.getAgency((BaseProduct)bp);
                }
                if (result.agent == null) {
                    result.agent = handler.findIssuingAgent(bp);
                }
                if (result.salesPoint == null) {
                    result.salesPoint = handler.findSalesPoint(bp);
                }
                if (result.issueDate != null) continue;
                result.issueDate = handler.findIssueDate(bp);
            }
        }
        return result;
    }

    private static class DeliveryContext {
        EntityReference<Organization> agency;
        EntityReference<Person> agent;
        EntityReference<SalesPoint> salesPoint;
        Date issueDate;

        DeliveryContext() {
        }
    }
}

