/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.v2;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGLogDocument;
import com.gridnine.xtrip.common.pg.model.PGLogItem;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentOption;
import com.gridnine.xtrip.common.pg.model.PaymentUpdate;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.model.PgPaymentIndex;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.rules.BookingCommissionsCalculator;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.v2.PaymentService;
import com.gridnine.xtrip.server.pg.v2.PaymentServiceHelper;
import com.gridnine.xtrip.server.pg.v2.PaymentServiceSettingsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentServiceImpl
implements PaymentService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<PgName, PGConnector> connectors = new HashMap<PgName, PGConnector>();

    public void configure() throws Exception {
        for (PGConnector connector : JpfUtil.getInstancesForExtension((String)"com.gridnine.xtrip.server.pg", (String)"PGConnectors", PGConnector.class)) {
            this.connectors.put(connector.getId(), connector);
        }
    }

    public void dispose() {
        Collection<PGConnector> col = this.connectors.values();
        this.connectors.clear();
        for (PGConnector connector : col) {
            connector.dispose();
        }
        this.log.debug("disposed");
    }

    @Override
    public List<PaymentOption> getPaymentOptions(EntityContainer<BookingFile> bfCtr) throws Exception {
        PaymentServiceSettingsProvider settingsProvider = (PaymentServiceSettingsProvider)Environment.getPublished(PaymentServiceSettingsProvider.class);
        ArrayList<PaymentOption> result = new ArrayList<PaymentOption>();
        for (PaymentType paymentType : settingsProvider.getAllowedPaymentTypes((BookingFile)bfCtr.getEntity())) {
            EntityContainer cloneCtr = new EntityContainer(BookingFile.class);
            XCloneModelHelper.copy(bfCtr, (BaseEntity)cloneCtr, (boolean)false);
            PaymentServiceHelper.updateFops((BookingFile)cloneCtr.getEntity(), paymentType);
            Reservation delivery = null;
            if (paymentType.name().contains("DELIVERY")) {
                delivery = PaymentServiceHelper.addFakeDelivery((EntityContainer<BookingFile>)cloneCtr, ContractType.CLIENT);
            }
            ArrayList messages = new ArrayList();
            HashMap params = new HashMap();
            ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(cloneCtr, true, true, messages, params, null);
            PaymentOption po = new PaymentOption();
            po.setPaymentType(paymentType);
            po.setPg(this.getPgByPaymentType(paymentType));
            po.setClientTotal(BookingHelper.getTotalPrice((BookingFile)((BookingFile)cloneCtr.getEntity()), (ContractType)ContractType.CLIENT));
            if (delivery != null) {
                ((BookingFile)cloneCtr.getEntity()).getReservations().remove(delivery);
                PaymentServiceHelper.addFakeDelivery((EntityContainer<BookingFile>)cloneCtr, ContractType.SUBAGENCY);
                ((BookingCommissionsCalculator)Environment.getPublished(BookingCommissionsCalculator.class)).applyRules(cloneCtr, true, true, messages, params, null);
            }
            po.setSubagencyTotal(BookingHelper.getTotalPrice((BookingFile)((BookingFile)cloneCtr.getEntity()), (ContractType)ContractType.SUBAGENCY));
            po.setSubagencyCommission(BookingHelper.getTotalCommission((BookingFile)((BookingFile)cloneCtr.getEntity()), (ContractType)ContractType.SUBAGENCY));
            result.add(po);
        }
        return result;
    }

    @Override
    public RedirectForm selectPaymentOption(EntityContainer<BookingFile> bfCtr, PaymentOption paymentOption, String pgReturnUrl) throws Exception {
        RedirectForm result = null;
        if (paymentOption.getPg() != null) {
            PaymentServiceSettingsProvider settingsProvider = (PaymentServiceSettingsProvider)Environment.getPublished(PaymentServiceSettingsProvider.class);
            ContractType contractType = settingsProvider.getPayerContractType((BookingFile)bfCtr.getEntity(), paymentOption.getPaymentType());
            PaymentInitiationParameters pip = new PaymentInitiationParameters();
            Payment payment = this.createPayment(bfCtr, contractType);
            payment.setPaymentType(paymentOption.getPaymentType());
            payment.setPg(paymentOption.getPg());
            pip.setPayment(payment);
            pip.setPg(paymentOption.getPg());
            pip.setReturnUrl(pgReturnUrl);
            pip.setSalesContext(SalesContextHelper.createSalesContext((Reservation)((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0))));
            PaymentInitiationResult pir = this.connectors.get(paymentOption.getPg()).initiatePayment(pip);
            EntityContainer paymentCtr = EntityContainer.create((BaseEntity)pir.getPayment());
            EntityStorage.get().save(paymentCtr, true);
            SysLogHelper.audit((EntityReference)paymentCtr.toReference(), (String)"initiatePayment", (Collection)pir.getMessages());
            this.saveLogItems(pir.getPgLog(), (EntityReference<Payment>)paymentCtr.toReference());
            result = pir.getRedirectForm();
        }
        PaymentServiceHelper.updateFops((BookingFile)bfCtr.getEntity(), paymentOption.getPaymentType());
        EntityStorage.get().save(bfCtr, true);
        SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"selectPaymentOption", (Message[])new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0412\u044b\u0431\u0440\u0430\u043d\u0430 \u0444\u043e\u0440\u043c\u0430 \u043e\u043f\u043b\u0430\u0442\u044b {0}", (Object[])new Object[]{paymentOption.getPaymentType()})});
        return result;
    }

    @Override
    public void updatePayment(PaymentUpdate paymentUpdate) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PgPaymentIndex.Property.pg.name(), (Object)paymentUpdate.getPg()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PgPaymentIndex.Property.paymentId.name(), (Object)paymentUpdate.getPaymentId()));
        List data = EntityStorage.get().search(PgPaymentIndex.class, query).getData();
        if (data.size() != 1) {
            throw new IllegalArgumentException(String.format("failed to resolve payment with paymentId='%s' (expected 1, found %d)", paymentUpdate.getPaymentId(), data.size()));
        }
        EntityContainer paymentCtr = EntityStorage.get().resolve(((PgPaymentIndex)data.get(0)).getSource());
        if (paymentUpdate.getStatus() != null) {
            ((Payment)paymentCtr.getEntity()).setStatus(paymentUpdate.getStatus());
        }
        if (paymentUpdate.getDetails() != null) {
            ((Payment)paymentCtr.getEntity()).setDetails(paymentUpdate.getDetails());
        }
        if (paymentUpdate.getPaymentType() != null) {
            ((Payment)paymentCtr.getEntity()).setPaymentType(paymentUpdate.getPaymentType());
        }
        if (paymentUpdate.getPgPaymentId() != null) {
            ((Payment)paymentCtr.getEntity()).setPgPaymentId(paymentUpdate.getPgPaymentId());
        }
        EntityStorage.get().save(paymentCtr, true);
        SysLogHelper.audit((EntityReference)paymentCtr.toReference(), (String)"updatePayment", (Collection)paymentUpdate.getMessages());
        this.saveLogItems(paymentUpdate.getPgLog(), (EntityReference<Payment>)paymentCtr.toReference());
    }

    private void saveLogItems(List<PGLogItem> items, EntityReference<Payment> ownerRef) {
        for (PGLogItem item : items) {
            EntityContainer docCtr = new EntityContainer(PGLogDocument.class);
            ((PGLogDocument)docCtr.getEntity()).setContentType(item.getContentType());
            ((PGLogDocument)docCtr.getEntity()).setOwner(ownerRef);
            ((PGLogDocument)docCtr.getEntity()).setName(item.getName());
            ((PGLogDocument)docCtr.getEntity()).setTitle(item.getTitle());
            ((PGLogDocument)docCtr.getEntity()).setCreated(item.getDate());
            ((PGLogDocument)docCtr.getEntity()).setContent(item.getTraceData());
            ((PGLogDocument)docCtr.getEntity()).setCheckSum(DigestUtils.md5Hex((byte[])((PGLogDocument)docCtr.getEntity()).getContent()));
            ((PGLogDocument)docCtr.getEntity()).setPg(item.getPg());
            ((PGLogDocument)docCtr.getEntity()).setPaymentId(item.getPaymentId());
            docCtr.getVersionInfo().setDataSource("server");
            EntityStorage.get().save(docCtr, true);
        }
    }

    private Payment createPayment(EntityContainer<BookingFile> bfCtr, ContractType contractType) {
        PaymentServiceSettingsProvider settingsProvider = (PaymentServiceSettingsProvider)Environment.getPublished(PaymentServiceSettingsProvider.class);
        Payment result = new Payment();
        result.setPaymentId(UUID.randomUUID().toString());
        result.setAmount(BookingHelper.getTotalPrice((BookingFile)((BookingFile)bfCtr.getEntity()), (ContractType)contractType));
        result.setFee(BookingHelper.getTotalFee((BookingFile)((BookingFile)bfCtr.getEntity()), (ContractType)contractType));
        result.setDescription(settingsProvider.buildPaymentDescription((BookingFile)bfCtr.getEntity()));
        if (((BookingFile)bfCtr.getEntity()).getCustomer() != null) {
            result.getCustomerInfo().setPreferredLocale(((BookingFile)bfCtr.getEntity()).getCustomer().getPreferredLocale());
        }
        result.setEntity(bfCtr.toReference());
        return result;
    }

    private PgName getPgByPaymentType(PaymentType paymentType) {
        for (PGConnector connector : this.connectors.values()) {
            if (!connector.getConnectorInfo().getSupportedPaymentTypes().contains(paymentType)) continue;
            return connector.getId();
        }
        return null;
    }
}

