/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.v2;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgPaymentIndex;
import com.gridnine.xtrip.common.pg.model.ProcessingStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.v2.PaymentServiceSettingsProvider;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PgPaymentTask
extends BaseScheduledTask {
    protected void doJob() throws Exception {
        PaymentServiceSettingsProvider provider = (PaymentServiceSettingsProvider)Environment.getPublished(PaymentServiceSettingsProvider.class);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PgPaymentIndex.Property.processingStatus.name(), (Object)ProcessingStatus.NOT_PROCESSED));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PgPaymentIndex.Property.status.name(), (Object)PaymentStatus.SUCCEEDED));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityEntityClassName", (Object)BookingFile.class.getName()));
        HashMap<String, HashSet<EntityReference>> data = new HashMap<String, HashSet<EntityReference>>();
        for (PgPaymentIndex pgPaymentIndex : EntityStorage.get().search(PgPaymentIndex.class, query).getData()) {
            HashSet<EntityReference> refs = (HashSet<EntityReference>)data.get(pgPaymentIndex.getEntity().getUid());
            if (refs == null) {
                refs = new HashSet<EntityReference>();
                data.put(pgPaymentIndex.getEntity().getUid(), refs);
            }
            refs.add(pgPaymentIndex.getSource());
        }
        block1: for (Map.Entry entry : data.entrySet()) {
            EntityContainer bfCtr = EntityStorage.get().resolve(new EntityReference((String)entry.getKey(), BookingFile.class, null));
            HashSet<EntityContainer<Payment>> ctrs = new HashSet<EntityContainer<Payment>>();
            BigDecimal paymentSum = BigDecimal.ZERO;
            PaymentType paymentType = null;
            for (EntityReference ref : (Set)entry.getValue()) {
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                paymentSum = paymentSum.add(((Payment)ctr.getEntity()).getAmount());
                if (paymentType == null) {
                    paymentType = ((Payment)ctr.getEntity()).getPaymentType();
                } else if (paymentType != ((Payment)ctr.getEntity()).getPaymentType()) {
                    ((BookingFile)bfCtr.getEntity()).setWorkflowStatus(WorkflowStatus.ERROR);
                    EntityStorage.get().save(bfCtr, true);
                    SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"error", Collections.singleton(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430 \u0438\u0437-\u0437\u0430 \u043d\u0435\u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0441\u0442\u0438 \u0444\u043e\u0440\u043c\u044b \u043e\u043f\u043b\u0430\u0442\u044b", (Object[])new Object[0])));
                    this.updateProcessingStatus(ctrs, ProcessingStatus.ERROR);
                    continue block1;
                }
                ctrs.add(ctr);
            }
            BigDecimal bfSum = BookingHelper.getTotalPrice((BookingFile)((BookingFile)bfCtr.getEntity()), (ContractType)provider.getPayerContractType((BookingFile)bfCtr.getEntity(), paymentType));
            int compare = bfSum.compareTo(paymentSum);
            if (compare > 0) continue;
            if (compare == 0) {
                ((BookingFile)bfCtr.getEntity()).setWorkflowStatus(WorkflowStatus.PAYED);
                EntityStorage.get().save(bfCtr, true);
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"payment", Collections.singleton(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0417\u0430\u043a\u0430\u0437 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043e\u043f\u043b\u0430\u0447\u0435\u043d", (Object[])new Object[0])));
                this.updateProcessingStatus(ctrs, ProcessingStatus.PROCESSED);
                EntityContainer btCtr = new EntityContainer(BillingTransaction.class);
                ((BillingTransaction)btCtr.getEntity()).setAgency(((BookingFile)bfCtr.getEntity()).getAgency());
                ((BillingTransaction)btCtr.getEntity()).setAgent(((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)).getBookingAgent());
                ((BillingTransaction)btCtr.getEntity()).setCategory(BillingTransactionCategory.DEBIT);
                ((BillingTransaction)btCtr.getEntity()).setClient(((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)).getSubagency());
                ((BillingTransaction)btCtr.getEntity()).setContractType(ContractType.SUBAGENCY);
                ((BillingTransaction)btCtr.getEntity()).setDate(new Date());
                ((BillingTransaction)btCtr.getEntity()).setEntity(bfCtr.toReference());
                ((BillingTransaction)btCtr.getEntity()).setPaymentType(provider.getSubagencyPaymentType(paymentType));
                ((BillingTransaction)btCtr.getEntity()).setStatus(BillingTransactionStatus.ACTIVE);
                ((BillingTransaction)btCtr.getEntity()).setSum(MoneyHelper.buildMoney((BigDecimal)paymentSum, (String)DictHelper.getEquivCurrency()));
                EntityStorage.get().save(btCtr, true);
                btCtr = new EntityContainer(BillingTransaction.class);
                ((BillingTransaction)btCtr.getEntity()).setAgency(((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)).getSubagency());
                ((BillingTransaction)btCtr.getEntity()).setAgent(((Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0)).getBookingAgent());
                ((BillingTransaction)btCtr.getEntity()).setCategory(BillingTransactionCategory.DEBIT);
                ((BillingTransaction)btCtr.getEntity()).setClient(((BookingFile)bfCtr.getEntity()).getCustomerProfile());
                ((BillingTransaction)btCtr.getEntity()).setContractType(ContractType.CLIENT);
                ((BillingTransaction)btCtr.getEntity()).setDate(new Date());
                ((BillingTransaction)btCtr.getEntity()).setEntity(bfCtr.toReference());
                ((BillingTransaction)btCtr.getEntity()).setPaymentType(provider.getSubagencyPaymentType(paymentType));
                ((BillingTransaction)btCtr.getEntity()).setStatus(BillingTransactionStatus.ACTIVE);
                ((BillingTransaction)btCtr.getEntity()).setSum(MoneyHelper.buildMoney((BigDecimal)paymentSum, (String)DictHelper.getEquivCurrency()));
                EntityStorage.get().save(btCtr, true);
                continue;
            }
            ((BookingFile)bfCtr.getEntity()).setWorkflowStatus(WorkflowStatus.ERROR);
            EntityStorage.get().save(bfCtr, true);
            SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"error", Collections.singleton(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0437\u0430\u043a\u0430\u0437\u0430", (Object[])new Object[0])));
            this.updateProcessingStatus(ctrs, ProcessingStatus.ERROR);
        }
    }

    private void updateProcessingStatus(Set<EntityContainer<Payment>> ctrs, ProcessingStatus status) {
        for (EntityContainer<Payment> ctr : ctrs) {
            ((Payment)ctr.getEntity()).setProcessingStatus(status);
            EntityStorage.get().save(ctr, true);
        }
    }
}

