/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.acbabank;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.acbabank.AcbaBankPgSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcbaBankPgHelper {
    private static final transient Logger log = LoggerFactory.getLogger(AcbaBankPgHelper.class);

    public static BigDecimal getTotalPrice(Payment payment, AcbaBankPgSettings settings, ContractType contractType, EntityContainer<BookingFile> bookingFile, PaymentType paymentType) throws PGException {
        try {
            BigDecimal totalPrice = settings.isTestingMode() ? BigDecimal.valueOf(settings.getTestAmount().intValue()) : (BigDecimal)PaymentHelper.getTotalPrices(bookingFile, (ContractType)contractType).get(payment.getPaymentType());
            return totalPrice;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PGException("Cannot get total price", (Throwable)e);
        }
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat priceFormat = new DecimalFormat("0", dfs);
        return priceFormat;
    }

    public static boolean isXmlAnswer(String response) {
        return response.startsWith("<");
    }

    public static void checkResponseForErrors(HttpResponse response) {
        if (response.getResponseCode() != 200) {
            throw Xeption.forAdmin((String)("Invalid response code " + response.getResponseCode()), (Object[])new Object[0]);
        }
        String answer = new String(response.getBody());
        if (!AcbaBankPgHelper.isXmlAnswer(answer)) {
            throw Xeption.forEndUser((String)answer, (Object[])new Object[0]);
        }
    }

    public static String getLanguage(PaymentInitiationParameters parameters) {
        Locale preferredLocale = parameters.getPayment().getCustomerInfo().getPreferredLocale();
        if (preferredLocale == null) {
            return null;
        }
        return preferredLocale.getLanguage();
    }
}

