/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.acbabank.initiate;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.acbabank.AcbaBankPgSettings;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.SimpleCompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.acbabank.AcbaBankPgHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.math.BigDecimal;
import java.net.URLEncoder;

public class InitiateRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AcbaBankPgSettings result = (AcbaBankPgSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUseTrustfulHostnameVerifier(true);
        httpRequest.setUseTrustfulManager(true);
        httpRequest.setRequestMethod(RequestMethod.GET);
        httpRequest.setUrl(result.getInitiateServiceUrl());
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
        this.fillParams(ctx, httpRequest);
    }

    private void fillParams(MessageContext ctx, HttpRequest httpRequest) throws Exception {
        PaymentInitiationParameters params = (PaymentInitiationParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        EntityContainer bookingFile = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        httpRequest.getQueryParameters().put((Object)"MODE", (Object)new String[]{"2"});
        Reservation baseProductReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
        PGParameters pgParams = (PGParameters)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.SALES_POINT_PG_PARAMETERS);
        httpRequest.getQueryParameters().put((Object)"MERCHANTNUMBER", (Object)new String[]{URLEncoder.encode(pgParams.getPgAccount())});
        httpRequest.getQueryParameters().put((Object)"MERCHANTPASSWD", (Object)new String[]{pgParams.getPgPassword()});
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        String paymentId = this.generatePaymentNumber();
        httpRequest.getQueryParameters().put((Object)"ORDERNUMBER", (Object)new String[]{paymentId});
        AcbaBankPgSettings settings = (AcbaBankPgSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        BigDecimal totalPrice = AcbaBankPgHelper.getTotalPrice(params.getPayment(), settings, ContractType.CLIENT, (EntityContainer<BookingFile>)bookingFile, payment.getPaymentType());
        httpRequest.getQueryParameters().put((Object)"AMOUNT", (Object)new String[]{AcbaBankPgHelper.getDecimalFormat().format(totalPrice.multiply(BigDecimal.valueOf(100.0)))});
        httpRequest.getQueryParameters().put((Object)"$ORDERDESCRIPTION", (Object)new String[]{URLEncoder.encode("Payment order " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)baseProductReservation), "UTF-8")});
        String language = AcbaBankPgHelper.getLanguage(params);
        if (TextUtil.isBlank((String)language)) {
            language = "RU";
        }
        httpRequest.getQueryParameters().put((Object)"LANGUAGE", (Object)new String[]{language});
        httpRequest.getQueryParameters().put((Object)"BACKURL", (Object)new String[]{URLEncoder.encode(params.getReturnUrl(), "UTF-8")});
        httpRequest.getQueryParameters().put((Object)"DEPOSITFLAG", (Object)new String[]{"0"});
    }

    private String generatePaymentNumber() throws Exception {
        SimpleCompositeNumber transactionNumber = new SimpleCompositeNumber();
        transactionNumber.setNumberPrefix(PgName.ACBABANK.name());
        ((SequenceNumberHelper)Environment.getPublished(SequenceNumberHelper.class)).generateInc((CompositeNumber)transactionNumber, Payment.class.getName(), null);
        return transactionNumber.getNumber();
    }
}

