/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.acbabank.initiate;

import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.acbabank.AcbaBankPgSettings;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.acbabank.AcbaBankPgHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class InitiateResponseParser
extends BaseProcessor {
    private static String[] supportedLanguages = new String[]{"am", "ru", "en"};

    public void process(MessageContext ctx) throws Exception {
        PaymentInitiationParameters params = (PaymentInitiationParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        HttpResponse response = (HttpResponse)ctx.getMandatoryObject(IBusHttpContextKeys.HTTP_RESPONSE.name());
        AcbaBankPgHelper.checkResponseForErrors(response);
        Element element = XUtil.fromBytes((byte[])response.getBody());
        String mdorder = XmlUtil.getValue((Element)XmlUtil.getElement((Element)element, (String)"/mdorder"));
        AcbaBankPgSettings result = (AcbaBankPgSettings)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_SETTINGS);
        String formUrl = result.getAcceptPaymentServiceUrl();
        String clientLanguage = AcbaBankPgHelper.getLanguage(params);
        formUrl = this.replaceLocale(clientLanguage, formUrl);
        PaymentInitiationResult resultParams = (PaymentInitiationResult)ctx.getMandatoryObject((Enum)IBusPgContextKeys.OUTPUT_PAYMENT_PARAMETERS);
        NamedValue nv = new NamedValue();
        nv.setName("MDORDER");
        nv.setValue(mdorder);
        resultParams.getRedirectForm().getParameters().add(nv);
        resultParams.getRedirectForm().setUrl(formUrl);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        payment.setPgPaymentId(mdorder);
    }

    public String replaceLocale(String clientLanguage, String formUrl) {
        if (!TextUtil.isBlank((String)clientLanguage)) {
            Pattern p;
            Matcher m;
            String language = clientLanguage.toLowerCase();
            if (Arrays.asList(supportedLanguages).contains(language) && (m = (p = Pattern.compile("(.*_)([a-z]{2})(\\.jsp)")).matcher(formUrl)).find()) {
                StringBuffer sb = new StringBuffer();
                sb.append(m.group(1));
                sb.append(language);
                sb.append(m.group(3));
                return sb.toString();
            }
        }
        return formUrl;
    }
}

