/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.pg.helpers.CommonPgFopInfoUtil;
import com.gridnine.xtrip.common.pg.model.CardPaymentStrategy;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.Consumers;
import com.gridnine.xtrip.server.pg.CreateFopsHandler;
import com.gridnine.xtrip.server.pg.PgCardBuilder;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.AssistPaymentScheme;
import com.gridnine.xtrip.server.pg.card.CardPaymentUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;

class AssistCreateFopsHandler
extends CreateFopsHandler {
    private AssistPaymentScheme paymentScheme;
    private CardPaymentStrategy cardPaymentStrategy;
    private String transaction;

    AssistCreateFopsHandler() {
    }

    public CreateFopsHandler prepare(EntityContainer<BookingFile> bookingFileCtr, Payment payment) throws NullPointerException {
        this.paymentScheme = AssistPGUtils.scheme(payment);
        this.cardPaymentStrategy = CardPaymentUtils.strategy((Payment)payment);
        this.transaction = AssistPGUtils.getValue(payment, AssistPGUtils.TRANSACTION_KEY);
        return super.prepare(bookingFileCtr, payment);
    }

    public void processAndSave() throws Exception {
        switch (this.paymentScheme) {
            case STANDARD: {
                super.processAndSave();
                return;
            }
            case CLIENT_FOPS: {
                this.updateClientFops();
                return;
            }
        }
        throw new IllegalStateException(String.format("paymentScheme=[%s] not supported", this.paymentScheme.name()));
    }

    private BiPredicate<? super BaseProduct, ? super GeneralProductFop> filterFop(Map<BaseProduct, Map<String, FopInfo>> selectedFops) {
        return (baseProduct, generalProductFop) -> ((Map)selectedFops.get(baseProduct)).containsKey(CommonPgFopInfoUtil.toId((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop));
    }

    private void updateClientFops() {
        Map<BaseProduct, List<FopInfo>> restoreSelectedFops = AssistPGUtils.restore((BookingFile)this.bookingFile.getEntity(), this.payment);
        Map<BaseProduct, Map<String, FopInfo>> selectedFops = AssistPGUtils.valueTransformation(restoreSelectedFops, FopInfo::getFopId, Function.identity());
        PgCardBuilder cardBuilder = new PgCardBuilder(this.payment.getDetails());
        Consumer<GeneralProductFop> updateFop = fop -> {
            fop.setOperationDate(new Date());
            fop.setType(this.payment.getPaymentType());
            fop.setCard(cardBuilder.build());
        };
        AssistPGUtils.updateProductAndFops((BookingFile)this.bookingFile.getEntity(), selectedFops::containsKey, Consumers.nothing(), this.filterFop(selectedFops), (baseProduct, generalProductFop) -> updateFop.accept((GeneralProductFop)generalProductFop));
        this.saveBookingFile();
    }
}

