/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SubProviderHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CirToken;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.CardPaymentStrategy;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheck;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheckStatus;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.InvoiceLineComposer;
import com.gridnine.xtrip.server.model.helpers.ActionSourceHelper;
import com.gridnine.xtrip.server.pg.CreateFopsHandler;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorInfoBuilder;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.PgPaymentBuilder;
import com.gridnine.xtrip.server.pg.PgTotalPriceProvider;
import com.gridnine.xtrip.server.pg.assist.AssistCardPaymentParametersBuilder;
import com.gridnine.xtrip.server.pg.assist.AssistCreateFopsHandler;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.AssistPaymentScheme;
import com.gridnine.xtrip.server.pg.assist.AssistPgPaymentBuilder;
import com.gridnine.xtrip.server.pg.assist.IBusAssistCommonContextKeys;
import com.gridnine.xtrip.server.pg.assist.PayOrder;
import com.gridnine.xtrip.server.pg.assist.PaymentInfo;
import com.gridnine.xtrip.server.pg.assist.PaymentValidator;
import com.gridnine.xtrip.server.pg.assist.SilentPay;
import com.gridnine.xtrip.server.pg.assist.SilentPayRequest;
import com.gridnine.xtrip.server.pg.assist.SilentPayResponse;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.card.CardPayment;
import com.gridnine.xtrip.server.pg.card.CardPaymentParameters;
import com.gridnine.xtrip.server.pg.card.CardPaymentParametersBuilder;
import com.gridnine.xtrip.server.pg.card.CardPaymentResult;
import com.gridnine.xtrip.server.pg.card.SelectCardContext;
import com.gridnine.xtrip.server.pg.handlers.PaymentStatusHandler;
import com.gridnine.xtrip.server.pg.handlers.PgHandlersRegistry;
import com.gridnine.xtrip.server.pg.helper.BookingFileHelper;
import com.gridnine.xtrip.server.pg.helper.TravellerHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.rules.proxy.PGParametersProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssistPGConnector
extends PGConnector
implements CardPayment {
    private boolean dispose;
    private Tracer tracer;

    public PgName getId() {
        return PgName.ASSIST;
    }

    public void dispose() {
        this.dispose = true;
        this.log.debug("dispose");
    }

    public PGConnectorInfo getConnectorInfo() {
        return PGConnectorInfoBuilder.buildInfo((PgName)this.getId(), (boolean)this.isEnabled(), (PaymentType[])new PaymentType[]{PaymentType.CREDIT_CARD_ASSIST, PaymentType.CREDIT_CARD_TRAVELLERS_ASSIST, PaymentType.CREDIT_CARD_TRAVELLERS_SPLIT_ASSIST});
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!this.isEnabled()) {
            return;
        }
        this.tracer = PGHelper.createTracer((PgName)this.getId());
        this.setQueueManager(new PaymentQueueManager(this.getQueuePeriod(), this.getId()));
        this.log.debug("configured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters initiationParameters) {
        this.requireNonDispose();
        Date startDate = new Date();
        Payment payment = initiationParameters.getPayment();
        AssistPaymentScheme initiationScheme = AssistPGUtils.scheme(payment);
        PaymentInitiationResult initiationResult = new PaymentInitiationResult();
        if (this.log.isDebugEnabled()) {
            this.log.debug("BEGIN initiatePayment()");
        }
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        try {
            initiationResult.setPayment(payment);
            if (!initiationParameters.isDontDoReprice()) {
                this.reprice(payment, initiationScheme);
            }
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)initiationParameters.getSalesContext(), (PgName)this.getId(), (Payment)payment);
            MerchantSettings merchantSettings = MerchantSettings.newInstance(pgParameters);
            PayOrder payOrder = new PayOrder(merchantSettings);
            payOrder.initiationPayment(initiationParameters, initiationResult);
            this.paymentInitiated(payment, initiationResult.getMessages());
            initiationResult.setSuccess(true);
            initiationResult.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d, \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u0432\u043b\u044f\u0435\u0442 {2}", (String)payment.getPaymentId(), (Object[])new Object[]{this.getId(), payment.getAmount()}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)initiationParameters, (Object)initiationResult, null);
            this.log.debug("END initiatePayment() success");
        }
        catch (Throwable t) {
            this.log.error(String.format("payment [%s] initiation failed", payment.getEntity()), t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            initiationResult.setSuccess(false);
            payment.setStatus(PaymentStatus.ERROR);
            initiationResult.getMessages().add(MessageHelper.createErrorMessage((String)t.getMessage(), (Object[])new Object[0]));
            initiationResult.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{this.getId()}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)initiationParameters, (Object)initiationResult, t);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, initiationResult.getPgLog());
        }
        return initiationResult;
    }

    private void reprice(Payment payment, AssistPaymentScheme initiationScheme) throws Exception {
        this.handlerFactory.createRepriceHandler().updatePayment(false).reprice(payment);
        EntityReference bookingFileRef = PaymentHelper.entityReference((Payment)payment, BookingFile.class);
        EntityContainer bookingFileCtr = EntityStorageHelper.resolve((EntityReference)bookingFileRef);
        AssistPgPaymentBuilder pgPaymentBuilder = (AssistPgPaymentBuilder)((AssistPgPaymentBuilder)new AssistPgPaymentBuilder().setBookingFileCtr(bookingFileCtr)).setPaymentType(payment.getPaymentType());
        switch (initiationScheme) {
            case STANDARD: {
                break;
            }
            case CLIENT_FOPS: {
                Map<BaseProduct, List<FopInfo>> restoreSelectedFops = AssistPGUtils.restore((BookingFile)bookingFileCtr.getEntity(), payment);
                pgPaymentBuilder.setClientFops(restoreSelectedFops);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("scheme=[%s] not supported", initiationScheme.name()));
            }
        }
        Payment newPayment = pgPaymentBuilder.build();
        BigDecimal paymentAmount = payment.getAmount();
        BigDecimal newPaymentAmount = newPayment.getAmount();
        if (paymentAmount.compareTo(newPaymentAmount) != 0) {
            throw new IllegalStateException(String.format("after reprice amount change from=[%s] to=[%s]", paymentAmount, newPaymentAmount));
        }
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters checkParameters, Map<String, Object> ctx) {
        return this.defaultCheckIBusPayment(checkParameters, ctx);
    }

    private void requireNonDispose() throws IllegalStateException {
        if (this.dispose) {
            throw new IllegalStateException("dispose");
        }
    }

    public Collection<PaymentType> supportedPaymentTypes() {
        return EnumSet.of(PaymentType.CREDIT_CARD_TRAVELLERS_ASSIST, PaymentType.CREDIT_CARD_TRAVELLERS_SPLIT_ASSIST);
    }

    public SelectCardContext newSelectCardContext(Person person, PaymentType paymentType, BookingFile bookingFile) {
        Predicate<Card> employmentCardsFilter;
        Objects.requireNonNull(person);
        Objects.requireNonNull(paymentType);
        Predicate<Card> filter = card -> true;
        if (PaymentType.CREDIT_CARD_TRAVELLERS_SPLIT_ASSIST == paymentType) {
            Airline carrier = BookingStreamHelper.getProductsStream((BookingFile)bookingFile, Product.class).map(Product::getCarrier).map(arg_0 -> ((DictionaryCache)DictionaryCache.get()).resolveReference(arg_0)).filter(Objects::nonNull).findAny().orElseThrow(() -> Xeption.forEndUser((String)"\u0412 \u0437\u0430\u043a\u0430\u0437\u0435 {0} \u043d\u0435 \u043d\u0430\u0448\u043b\u043e\u0441\u044c \u0432\u0430\u043b\u0438\u0434\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430", (Object[])new Object[]{TextUtil.buildFullNumber((CompositeNumber)bookingFile)}));
            Set acceptableCardVendors = carrier.getAcceptableCards().stream().filter(Objects::nonNull).map(AirlineCard::getVendor).filter(Objects::nonNull).collect(Collectors.toSet());
            filter = card -> acceptableCardVendors.contains(card.getVendor());
        }
        if (this.isSabreHS(bookingFile)) {
            Predicate<Card> f = filter;
            employmentCardsFilter = card -> f.test((Card)card) && !card.isBta();
        } else {
            employmentCardsFilter = filter;
        }
        return new SelectCardContext(person, filter, employmentCardsFilter);
    }

    private boolean isSabreHS(BookingFile bookingFile) {
        boolean result = false;
        block0: for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                HotelProduct hotelProduct;
                String providerName;
                if (!(product instanceof HotelProduct) || !"HOTELSTAR".equals(providerName = (hotelProduct = (HotelProduct)product).getProvider() != null ? hotelProduct.getProvider().name() : null) || hotelProduct.getSubProvider() == null || !SubProviderHelper.subproviderIsSabre((DictionaryReference)hotelProduct.getSubProvider())) continue;
                result = true;
                break block0;
            }
        }
        return result;
    }

    public List<Card> cards(SelectCardContext selectCardContext) throws RuntimeException {
        Objects.requireNonNull(selectCardContext);
        Person person = selectCardContext.getPerson();
        CirToken cirToken = CirHelper.cirToken((Person)person);
        if (Objects.isNull(cirToken)) {
            return Collections.emptyList();
        }
        List personCirCards = CirHelper.cirCardStream((Collection)person.getCards()).filter(selectCardContext.getFilter()).filter(Objects::nonNull).collect(Collectors.toList());
        EntityContainer mainEmploymentCtr = ProfileHelper.getMainEmployment((Person)person);
        Organization mainEmployment = (Organization)mainEmploymentCtr.getEntity();
        List mainEmploymentCirCards = CirHelper.cirCardStream((Collection)mainEmployment.getCards()).filter(selectCardContext.getEmploymentCardsFilter()).filter(Objects::nonNull).collect(Collectors.toList());
        return Stream.concat(personCirCards.stream(), mainEmploymentCirCards.stream()).collect(Collectors.toList());
    }

    public String validateTraveller(Traveller traveller) {
        return TravellerHelper.validate((Traveller)traveller);
    }

    public PgPaymentBuilder newPaymentBuilder() {
        return new AssistPgPaymentBuilder();
    }

    public CardPaymentParametersBuilder newCardPaymentParametersBuilder() {
        return new AssistCardPaymentParametersBuilder();
    }

    private void validate(CardPaymentParameters cardPaymentParameters) {
        this.requireNonDispose();
        Objects.requireNonNull(cardPaymentParameters);
        Payment payment = cardPaymentParameters.getPayment();
        BookingFile bookingFile = (BookingFile)cardPaymentParameters.getBookingFileCtr().getEntity();
        Collection reservations = PaymentHelper.getReservations((BookingFile)bookingFile, (Collection)payment.getReservations());
        Xeption workflowStatusXeption = PGHelper.checkWorkflowStatus((BookingFile)bookingFile, (Collection)reservations);
        if (workflowStatusXeption != null) {
            throw workflowStatusXeption;
        }
        PaymentInfo paymentInfo = new PaymentInfo(payment);
        PaymentValidator.validate(paymentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardPaymentResult cardPayment(CardPaymentParameters cardPaymentParameters) throws NullPointerException {
        this.validate(cardPaymentParameters);
        CardPaymentResult.Builder cardPaymentResultBuilder = new CardPaymentResult.Builder().setSuccess(false);
        Date startDate = new Date();
        if (this.log.isDebugEnabled()) {
            this.log.debug("BEGIN card payment");
        }
        PGInvocationContext.get().begin(InvocationName.CARD_PAYMENT.toString());
        EntityContainer bookingFileCtr = cardPaymentParameters.getBookingFileCtr();
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        try {
            SalesContext salesContext = cardPaymentParameters.getSalesContext();
            Payment payment = cardPaymentParameters.getPayment();
            PGParametersProperties pgParametersProperties = PGParametersProperties.newInstance((PgName)this.getId(), (BookingFile)bookingFile, (PaymentType)payment.getPaymentType());
            PGParameters pgParameters = PGRulesHelper.newPgParameters((SalesContext)salesContext, (PGParametersProperties)pgParametersProperties);
            MerchantSettings merchantSettings = MerchantSettings.newInstance(pgParameters);
            Traveller traveller = BookingFileHelper.traveller((BookingFile)bookingFile);
            Card card = cardPaymentParameters.getCard();
            Locale preferredAssistCheckLocale = AssistPGUtils.getPreferredAssistCheckLocale(traveller, bookingFile);
            payment.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.PREFERRED_CHECK_LOCALE_KEY, (String)preferredAssistCheckLocale.toLanguageTag()));
            SilentPayRequest silentPayRequest = SilentPayRequest.newBuilder(merchantSettings, bookingFile, payment, card, traveller, preferredAssistCheckLocale).setFormat(Format.XML).build();
            payment.setPaymentDate(new Date());
            payment.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.ORDER_COMMENT_KEY, (String)silentPayRequest.getOrderComment()));
            this.addToQueue(payment);
            this.createAndSavePgPaymentCheck(payment, salesContext);
            SilentPay silentPay = new SilentPay();
            SilentPayResponse silentPayResponse = silentPay.invoke(silentPayRequest);
            if (!silentPayResponse.isSuccess()) {
                String errorMessage = silentPayResponse.getErrorMessage();
                cardPaymentResultBuilder.setSuccess(false).setErrorMessage(errorMessage);
                throw Xeption.forDeveloper((String)errorMessage, (Object[])new Object[0]);
            }
            payment.setDetails(SilentPay.toCardTransactionDetails(card, silentPayResponse));
            payment.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.CHECK_PARAMETERS_KEY, (String)AssistPGUtils.toXmlString(silentPayResponse.getCheckParameter())));
            this.updateToQueue(payment);
            ArrayList<Message> messages = new ArrayList<Message>(silentPayResponse.getMessages());
            LockUtil.lock((EntityContainer)bookingFileCtr, reloadBookingFileCtr -> {
                HashMap<String, Object> ctx = new HashMap<String, Object>();
                ctx.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bookingFileCtr);
                ctx.put(IBusPgConnectorContextKeys.PAYMENT.name(), payment);
                PaymentCheckParameters checkParameters = new PaymentCheckParameters();
                checkParameters.setSalesContext(salesContext);
                checkParameters.setPayment(payment);
                PaymentCheckResult paymentCheckResult = this.checkPayment(checkParameters, ctx);
                if (!paymentCheckResult.isSuccess()) {
                    throw (Xeption)ctx.getOrDefault(IBusPgConnectorContextKeys.DETAILED_XEPTION.name(), Xeption.forDeveloper((String)"Assist check fail", (Object[])new Object[0]));
                }
                cardPaymentResultBuilder.setSlipDocument((EntityContainer)ctx.get(IBusAssistCommonContextKeys.SLIP.name()));
            });
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CARD_PAYMENT.toString(), (Object)cardPaymentParameters, (Object)cardPaymentResultBuilder.setSuccess(true).build(), null);
            if (this.log.isDebugEnabled()) {
                this.log.debug("END card payment");
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("error while cardPayment for bookingFile " + bookingFile, (Throwable)e);
            }
            if (Objects.isNull(cardPaymentResultBuilder.getErrorMessage())) {
                cardPaymentResultBuilder.setErrorMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CARD_PAYMENT.toString(), (Object)cardPaymentParameters, (Object)cardPaymentResultBuilder.setSuccess(false).build(), (Throwable)e);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, new ArrayList());
        }
        return cardPaymentResultBuilder.build();
    }

    private void createAndSavePgPaymentCheck(Payment payment, SalesContext salesContext) {
        PgPaymentCheck pgPaymentCheck = new PgPaymentCheck();
        pgPaymentCheck.setPgName(payment.getPg());
        pgPaymentCheck.setStatus(PgPaymentCheckStatus.NEW);
        pgPaymentCheck.setPaymentId(payment.getPaymentId());
        pgPaymentCheck.setSalesContext(salesContext);
        pgPaymentCheck.setUpdated(new Date());
        pgPaymentCheck.setHandled(MiscUtil.addMinutesToDate((Date)new Date(), (int)30));
        EntityContainer pgPaymentCheckCtr = EntityContainer.create((BaseEntity)pgPaymentCheck);
        VersionInfo versionInfo = pgPaymentCheckCtr.getVersionInfo();
        versionInfo.setDataSource("pg-assist");
        versionInfo.setVersionNotes(((Object)((Object)this)).getClass().getName());
        EntityStorage.get().save(pgPaymentCheckCtr, true);
    }

    public String defaultComment(BookingFile bf, Locale locale) {
        return InvoiceLineComposer.getInstance().buildComment(bf, locale);
    }

    public void paymentSucceeded(Payment payment, List<Message> messages, SalesContext salesContext, EntityContainer<BookingFile> bookingFileCtr) {
        PaymentStatusHandler paymentStatusHandler = PgHandlersRegistry.getPaymentStatusHandler().orElse(null);
        PgTotalPriceProvider totalPriceProvider = (reference, paymentType) -> payment.getAmount();
        this.handlerFactory.createPaymentSucceedHandler().setCreateFopsHandler((CreateFopsHandler)new AssistCreateFopsHandler()).setBookingFile(bookingFileCtr).process(paymentStatusHandler, this.getQueueManager(), totalPriceProvider, payment, messages, salesContext);
    }

    public CardPaymentStrategy strategy(ActionSource actionSource, PaymentType paymentType, EntityContainer<BookingFile> bookingFileCtr) {
        if (PaymentType.CREDIT_CARD_TRAVELLERS_SPLIT_ASSIST == paymentType) {
            return CardPaymentStrategy.ASSIST_SPLIT;
        }
        CardPaymentStrategy standard = CardPaymentStrategy.STANDARD;
        if (!ActionSourceHelper.get().isSite(actionSource)) {
            return standard;
        }
        if (PaymentType.CREDIT_CARD_TRAVELLERS_ASSIST != paymentType) {
            return standard;
        }
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        boolean isSeparateSupplierFees = Optional.ofNullable(bookingFile).map(BookingFile::getCustomerProfile).map(EntityStorageHelper::resolve).map(EntityContainer::getEntity).filter(Organization::isSeparateSupplierFees).isPresent();
        if (!isSeparateSupplierFees) {
            return standard;
        }
        Map<BaseProduct, List<FopInfo>> unpaidFops = AssistPGUtils.unpaidFopsWithApplyRules(bookingFileCtr, paymentType);
        Map<BaseProduct, Map<String, List<? super FopInfo>>> unpaidByTransactionFops = AssistPGUtils.valueTransformation(unpaidFops, Collectors.groupingBy(AssistPGUtils.transaction()));
        boolean exists1 = unpaidByTransactionFops.entrySet().stream().map(Map.Entry::getValue).filter(map -> map.keySet().contains("FIRST_TRANSACTION")).anyMatch(map -> CollectionUtil.isNotEmpty(map.values()));
        boolean exists2 = unpaidByTransactionFops.entrySet().stream().map(Map.Entry::getValue).filter(map -> map.keySet().contains("SECOND_TRANSACTION")).anyMatch(map -> CollectionUtil.isNotEmpty(map.values()));
        return exists1 && exists2 ? CardPaymentStrategy.ASSIST_TWO_TRANSACTIONS : standard;
    }
}

