/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.pg.assist.AssistSettings;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AssistPGPublisher
implements Publisher {
    private static final Logger log = Logger.getLogger(AssistPGPublisher.class);

    public void publish() throws Exception {
        this.publishAssistSetting();
    }

    private void publishAssistSetting() throws Exception {
        if (AssistPGUtils.getSettings() != null) {
            return;
        }
        String lockKey = LockUtil.getLockKey(AssistPGUtils.ASSIST_SETTINGS_ENTITY_REFERENCE);
        LockUtil.lock((String)lockKey, () -> {
            EntityContainer settings = AssistPGUtils.getSettings();
            if (settings != null) {
                return;
            }
            settings = EntityContainer.create((BaseEntity)new AssistSettings(), (String)AssistPGUtils.ASSIST_SETTINGS_ENTITY_REFERENCE.getUid());
            settings.setCreatedBy("system");
            settings.setCreated(new Date());
            settings.getVersionInfo().setCreatedBy("system");
            settings.getVersionInfo().setCreated(new Date());
            settings.getVersionInfo().setDataSource("system");
            settings.getVersionInfo().setVersionNotes("from publisher");
            ((AssistSettings)settings.getEntity()).setName(MetaRegistryHelper.getDisplayName(AssistSettings.class, (Locale)LocaleUtil.LOCALE_RU));
            ((AssistSettings)settings.getEntity()).setPgName(PgName.ASSIST);
            ((AssistSettings)settings.getEntity()).setType(SystemSettingsType.PG_CONFIGURATION);
            File file = PGHelper.getConfigurationFile((PgName)PgName.ASSIST, (boolean)false);
            if (file.exists()) {
                Properties config = new Properties();
                try (FileInputStream inputStream = new FileInputStream(file);){
                    config.load(inputStream);
                    ((AssistSettings)settings.getEntity()).setServerUrl(config.getProperty("serverUrl", null));
                    try {
                        String contractTypeStr = config.getProperty("contractType", null);
                        if (TextUtil.nonBlank((String)contractTypeStr)) {
                            ((AssistSettings)settings.getEntity()).setContractType(ContractType.valueOf((String)contractTypeStr));
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)"failed set contract type", t);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("failed loading configuration from file " + file), (Throwable)e);
                }
            }
            EntityStorage.get().save(settings, true);
        });
    }
}

