/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.CreateFopsHandler;
import com.gridnine.xtrip.server.pg.HandlersFactory;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.PaymentSucceedHandler;
import com.gridnine.xtrip.server.pg.PgTotalPriceProvider;
import com.gridnine.xtrip.server.pg.assist.AssistCreateFopsHandler;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.AssistPaymentScheme;
import com.gridnine.xtrip.server.pg.assist.AssistPgPaymentBuilder;
import com.gridnine.xtrip.server.pg.assist.OrderResult;
import com.gridnine.xtrip.server.pg.assist.PayOrderResult;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultRequest;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultResponse;
import com.gridnine.xtrip.server.pg.handlers.PaymentStatusHandler;
import com.gridnine.xtrip.server.pg.handlers.PgHandlersRegistry;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssistPGServlet
extends PGServlet {
    private static final long serialVersionUID = -6505129164717973186L;
    private static final Logger log = LoggerFactory.getLogger(AssistPGServlet.class);

    protected PgName getId() {
        return PgName.ASSIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AssistPGServlet.log.debug("AssistPGServlet service() BEGIN");
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        startServiceDate = new Date();
        pgServletResponse = new PGServletResponse(response);
        requestParameters = request.getParameterMap();
        logParameters = PGHelper.toLogParameters((Map)requestParameters);
        pgLog = new ArrayList<E>();
        messages = new ArrayList<Message>();
        payment = null;
        bookingFileRef = null;
        try {
            LogicalStorage.get().setUser("system");
            payOrderResult = PayOrderResult.newInstance(requestParameters);
            paymentId = payOrderResult.getOrderNumber();
            payment = this.getFromQueue(paymentId);
            Objects.requireNonNull(payment, "can't find payment by " + paymentId);
            PGInvocationContext.get().setPaymentId(payment.getPaymentId());
            switch (payOrderResult.getStatus()) {
                case 1: {
                    payment.setStatus(PaymentStatus.INITIATED);
                    messages.add(MessageHelper.createMessage((String)"\u0423\u0441\u043f\u0435\u0448\u043d\u0430\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f. \u0421\u0442\u0430\u0442\u0443\u0441: \u041f\u043b\u0430\u0442\u0451\u0436 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d.", (Object[])new Object[0]));
                    ** break;
                }
            }
            messages.add(MessageHelper.createMessage((String)("\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430. \u0421\u0442\u0430\u0442\u0443\u0441: \u041f\u043b\u0430\u0442\u0451\u0436 \u043e\u0442\u043c\u0435\u043d\u0451\u043d. \u041a\u043e\u0434=" + payOrderResult.getStatus()), (Object[])new Object[0]));
            this.paymentFailed(payment, messages);
            ** GOTO lbl55
        }
        catch (Throwable t) {
            try {
                AssistPGServlet.log.error("AssistPGServlet service() FAILED", t);
                PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, t);
                pgServletResponse.setResponseText(t.getMessage());
                if (Objects.nonNull(payment)) {
                    PGHelper.redirect((PGServletResponse)pgServletResponse, (String)this.buildRedirectUrl(payment, AssistPGUtils.ERROR_URL_SITE_KEY));
                }
                pgServletResponse.setResponseCode(500);
            }
            catch (Throwable var15_19) {
                AssistPGServlet.log.debug("AssistPGServlet service() END");
                PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, null);
                PGInvocationContext.get().end(this.getConnector(), pgLog);
                if (Objects.nonNull(payment)) {
                    PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
                    try {
                        this.getConnector().removeFromQueue(payment);
                    }
                    catch (Exception e) {
                        AssistPGServlet.log.error("AssistPGServlet service() FAILED remove payment", (Throwable)e);
                    }
                }
                if (Objects.nonNull(bookingFileRef)) {
                    SysLogHelper.audit(bookingFileRef, (String)"pg-connector", messages);
                }
                pgServletResponse.send();
                LogicalStorage.reset();
                throw var15_19;
            }
lbl55:
            // 1 sources

            AssistPGServlet.log.debug("AssistPGServlet service() END");
            PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, null);
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (Objects.nonNull(payment)) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
                try {
                    this.getConnector().removeFromQueue(payment);
                }
                catch (Exception e) {
                    AssistPGServlet.log.error("AssistPGServlet service() FAILED remove payment", (Throwable)e);
                }
            }
            if (Objects.nonNull(bookingFileRef)) {
                SysLogHelper.audit((EntityReference)bookingFileRef, (String)"pg-connector", messages);
            }
            pgServletResponse.send();
            LogicalStorage.reset();
            return;
lbl-1000:
            // 1 sources

            {
                bookingFileRef = PaymentHelper.entityReference((Payment)payment, BookingFile.class);
                handlePayment = payment;
                scheme = AssistPGUtils.scheme(payment);
                LockUtil.lock((EntityReference)bookingFileRef, (LockUtil.RunnableWithParameterAndException)(LockUtil.RunnableWithParameterAndException)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$service$0(com.gridnine.xtrip.common.pg.model.Payment java.util.List com.gridnine.xtrip.server.pg.assist.AssistPaymentScheme com.gridnine.xtrip.server.pg.PGServletResponse com.gridnine.xtrip.common.model.EntityContainer ), (Lcom/gridnine/xtrip/common/model/EntityContainer;)V)((AssistPGServlet)this, (Payment)handlePayment, messages, (AssistPaymentScheme)scheme, (PGServletResponse)pgServletResponse));
                AssistPGServlet.log.debug("AssistPGServlet service() FINISH");
            }
            AssistPGServlet.log.debug("AssistPGServlet service() END");
            PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, null);
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (Objects.nonNull(payment)) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
                try {
                    this.getConnector().removeFromQueue(payment);
                }
                catch (Exception e) {
                    AssistPGServlet.log.error("AssistPGServlet service() FAILED remove payment", (Throwable)e);
                }
            }
            if (Objects.nonNull(bookingFileRef)) {
                SysLogHelper.audit((EntityReference)bookingFileRef, (String)"pg-connector", messages);
            }
            pgServletResponse.send();
            LogicalStorage.reset();
            return;
            AssistPGServlet.log.debug("AssistPGServlet service() END");
            PGInvocationContext.get().addTraceData(0, startServiceDate, InvocationName.SERVLET_SERVICE.toString(), (Object)logParameters, (Object)pgServletResponse, null);
            PGInvocationContext.get().end(this.getConnector(), pgLog);
            if (Objects.nonNull(payment)) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
                try {
                    this.getConnector().removeFromQueue(payment);
                }
                catch (Exception e) {
                    AssistPGServlet.log.error("AssistPGServlet service() FAILED remove payment", (Throwable)e);
                }
            }
            if (Objects.nonNull(bookingFileRef)) {
                SysLogHelper.audit((EntityReference)bookingFileRef, (String)"pg-connector", messages);
            }
            pgServletResponse.send();
            LogicalStorage.reset();
            return;
        }
    }

    private PgTotalPriceProvider totalPriceProvider(EntityContainer<BookingFile> bookingFileCtr, Payment payment, AssistPaymentScheme scheme) {
        return (reference, paymentType) -> {
            AssistPgPaymentBuilder assistPgPaymentBuilder = (AssistPgPaymentBuilder)((AssistPgPaymentBuilder)new AssistPgPaymentBuilder().setBookingFileCtr(bookingFileCtr)).setPaymentType(paymentType);
            switch (scheme) {
                case STANDARD: {
                    break;
                }
                case CLIENT_FOPS: {
                    Map<BaseProduct, List<FopInfo>> restoreSelectedFops = AssistPGUtils.restore((BookingFile)bookingFileCtr.getEntity(), payment);
                    assistPgPaymentBuilder.setClientFops(restoreSelectedFops);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("scheme=[%s] not supported", scheme.name()));
                }
            }
            return assistPgPaymentBuilder.build().getAmount();
        };
    }

    private String buildRedirectUrl(Payment payment, String urlKey) {
        List customParameters = payment.getCustomParameters();
        String returnDomainUrl = NamedValueHelper.getValueForName((String)AssistPGUtils.RETURN_DOMAIN_URL_SITE_KEY, (Collection)customParameters);
        String url = NamedValueHelper.getValueForName((String)urlKey, (Collection)customParameters);
        return returnDomainUrl + url;
    }

    private /* synthetic */ void lambda$service$0(Payment handlePayment, List messages, AssistPaymentScheme scheme, PGServletResponse pgServletResponse, EntityContainer bookingFileCtr) throws Exception {
        Objects.requireNonNull(bookingFileCtr, "reload bookingFile fail");
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        if (WorkflowStatus.PAYED == bookingFile.getWorkflowStatus()) {
            log.trace("BookingFile already payed");
            return;
        }
        OrderResult orderResult = new OrderResult();
        SalesContext salesContext = SalesContextHandler.get().createSalesContext((Reservation)CollectionUtil.head((Iterable)bookingFile.getReservations()));
        PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)salesContext, (PgName)this.getId(), (Payment)handlePayment);
        MerchantSettings merchantSettings = MerchantSettings.newInstance(pgParameters);
        OrderResultRequest orderResultRequest = AssistPGUtils.newOrderResultRequest(merchantSettings, handlePayment, Format.XML);
        OrderResultResponse orderResultResponse = orderResult.invoke(orderResultRequest);
        if (!orderResultResponse.isSuccessResponse()) {
            throw new IllegalStateException("fail response");
        }
        if (!orderResultResponse.isOrderPaid()) {
            throw new IllegalStateException(String.format("order=[%s] not paid", TextUtil.buildFullNumber((CompositeNumber)bookingFile)));
        }
        handlePayment.setDetails(orderResultResponse.cardTransactionDetails());
        messages.add(AssistPGUtils.createApproveCodeMessage(orderResultResponse.approvalCode()));
        HandlersFactory handlerFactory = this.getConnector().getHandlerFactory();
        Optional paymentStatusHandler = PgHandlersRegistry.getPaymentStatusHandler();
        PgTotalPriceProvider totalPriceProvider = this.totalPriceProvider((EntityContainer<BookingFile>)bookingFileCtr, handlePayment, scheme);
        PaymentSucceedHandler paymentSucceedHandler = handlerFactory.createPaymentSucceedHandler().setCreateFopsHandler((CreateFopsHandler)new AssistCreateFopsHandler()).setBookingFile(bookingFileCtr);
        paymentSucceedHandler.process((PaymentStatusHandler)paymentStatusHandler.orElse(null), this.getConnector().getQueueManager(), totalPriceProvider, handlePayment, messages, salesContext);
        PGHelper.redirect((PGServletResponse)pgServletResponse, (String)this.buildRedirectUrl(handlePayment, AssistPGUtils.SUCCESS_URL_SITE_KEY));
    }
}

