/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.bof.midoffice.helper.PDFContent;
import com.gridnine.bof.midoffice.helper.PDFContentPart;
import com.gridnine.bof.midoffice.helper.PDFUtil;
import com.gridnine.xtrip.common.meta.XSerializableMap;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.assist.AssistSettings;
import com.gridnine.xtrip.common.pg.helpers.CommonPgFopInfoUtil;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.assist.AssistPaymentScheme;
import com.gridnine.xtrip.server.pg.assist.model.CheckParameter;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultRequest;
import com.gridnine.xtrip.server.pg.assist.model.Parameter;
import com.gridnine.xtrip.server.pg.card.CardPaymentUtils;
import com.gridnine.xtrip.server.pg.helper.AllowedPaymentTypesHandler;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public final class AssistPGUtils {
    private static final Locale DEFAULT_PREFERRED_LOCALE = LocaleUtil.LOCALE_RU;
    static final Pattern LATIN_SYMBOLS_PATTERN = Pattern.compile("^[a-zA-Z- ]+$");
    static final Pattern CYRILLIC_SYMBOLS_PATTERN = Pattern.compile("^[\u0430-\u044f\u0410-\u042f- ]+$");
    public static final String ORDER_NUMBER_KEY = AssistPGUtils.class.getName() + ".orderNumber";
    public static final String CHECK_PARAMETERS_KEY = AssistPGUtils.class.getName() + ".checkParameters";
    public static final String ORDER_COMMENT_KEY = AssistPGUtils.class.getName() + ".orderComment";
    public static final String PREFERRED_CHECK_LOCALE_KEY = AssistPGUtils.class.getName() + ".preferredCheckLocaleKey";
    public static final String TRANSACTION_KEY = AssistPGUtils.class.getName() + ".transaction";
    public static final String FIRST_TRANSACTION = "FIRST_TRANSACTION";
    public static final String SECOND_TRANSACTION = "SECOND_TRANSACTION";
    static final EntityReference<AssistSettings> ASSIST_SETTINGS_ENTITY_REFERENCE = new EntityReference("assist-pg-configuration", AssistSettings.class, null);
    public static final ThreadLocal<DecimalFormat> PRICE_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.00", dfs);
        decimalFormat.setParseBigDecimal(true);
        return decimalFormat;
    });
    static final String SUCCESS_URL_SITE_KEY = AssistPGUtils.class.getName() + ".successUrl";
    static final String ERROR_URL_SITE_KEY = AssistPGUtils.class.getName() + ".errorUrl";
    static final String RETURN_DOMAIN_URL_SITE_KEY = AssistPGUtils.class.getName() + ".returnDomainUrl";
    static final String SELECTED_UNPAID_CLIENT_FOPS_KEY = AssistPGUtils.class.getName() + ".selectedUnpaidClientFops";
    public static final String CLIENT_FOPS_KEY = AssistPGUtils.class.getName() + ".clientFops";
    private static final Map<Locale, String> CHECK_TEMPLATES = new HashMap<Locale, String>();

    private AssistPGUtils() {
        throw new IllegalStateException("please don't create");
    }

    static EntityContainer<AssistSettings> getSettings() {
        return EntityStorageHelper.resolve(ASSIST_SETTINGS_ENTITY_REFERENCE);
    }

    static BigDecimal orderPrice(EntityContainer<BookingFile> bookingFile, PaymentType paymentType, Card card) throws Exception {
        Objects.requireNonNull(bookingFile, "no BookingFile");
        Objects.requireNonNull(paymentType, "no PaymentType");
        ContractType contractType = ((AssistSettings)AssistPGUtils.getSettings().getEntity()).getContractType();
        Objects.requireNonNull(contractType, "no ContractType");
        Set allowedPaymentTypes = AllowedPaymentTypesHandler.get().getAllowedPaymentTypes(bookingFile);
        return (BigDecimal)PaymentHelper.getTotalPrices(bookingFile, null, (ContractType)contractType, (Set)allowedPaymentTypes, null, (Card)card).get(paymentType);
    }

    public static String getValue(Payment payment, String key) {
        Objects.requireNonNull(payment);
        Objects.requireNonNull(key);
        return Optional.of(payment).map(Payment::getCustomParameters).map(namedValues -> NamedValueHelper.getValueForName((String)key, (Collection)namedValues)).orElse(null);
    }

    public static AssistPaymentScheme scheme(Payment payment) {
        String clientFops = AssistPGUtils.getValue(payment, CLIENT_FOPS_KEY);
        AssistPaymentScheme initiationScheme = Objects.nonNull(clientFops) ? AssistPaymentScheme.CLIENT_FOPS : AssistPaymentScheme.STANDARD;
        return initiationScheme;
    }

    static Message createApproveCodeMessage(String approveCode) {
        return SystemHelper.createMessage((MessageType)MessageType.FOR_USER, (String)"Assist approve code={0}", (Object[])new Object[]{approveCode});
    }

    static List<NameValuePair> toNameValuePairs(Map<Parameter, String> parameterMap) {
        Objects.requireNonNull(parameterMap);
        return parameterMap.entrySet().stream().map(entry -> AssistPGUtils.toNameValuePair((Parameter)((Object)((Object)entry.getKey())), (String)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static NameValuePair toNameValuePair(Parameter parameter, String value) {
        if (Objects.isNull((Object)parameter) || Objects.isNull(value)) {
            return null;
        }
        return new BasicNameValuePair(parameter.origin(), value);
    }

    /*
     * Exception decompiling
     */
    static <R> R resourceHandler(String fileName, Streams.CheckedFunction<Reader, R> function) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Map<String, String> loadProperties(String fileName) throws Exception {
        return (Map)AssistPGUtils.resourceHandler(fileName, reader -> {
            Properties properties = new Properties();
            properties.load((Reader)reader);
            return properties.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString()));
        });
    }

    public static Document toCheckDocument(byte[] pdfContent) {
        Document document = new Document();
        document.setType(DocumentType.RECEIPT);
        document.setContentType(ContentType.PDF);
        document.setCreated(new Date());
        document.setTitle("\u0427\u0435\u043a \u043f\u043e \u043e\u043f\u043b\u0430\u0442\u0435 Assist");
        document.setName("receipt.pdf");
        document.setContent(pdfContent);
        return document;
    }

    public static byte[] toPdfContent(String text) throws Exception {
        PDFContentPart pdfContentPart = new PDFContentPart();
        pdfContentPart.setText(text);
        pdfContentPart.setFontSize(11.0f);
        return PDFUtil.wrapAsPDF((String)"", (PDFContent[])new PDFContent[]{pdfContentPart});
    }

    public static String toHttpRow(Parameter parameter, String value, String charset) {
        try {
            return URLEncoder.encode(parameter.origin(), charset) + "=" + URLEncoder.encode(value, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> String toXmlString(Map<K, V> map) {
        Objects.requireNonNull(map);
        XSerializableMap xSerializableMap = new XSerializableMap();
        xSerializableMap.putAll(map);
        try {
            return XSUtil.toString((XSSerializable)xSerializableMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <K, V> Map<K, V> fromXmlString(String xml, Supplier<Map<K, V>> mapSupplier) {
        try {
            XSerializableMap xSerializableMap = new XSerializableMap();
            XUtil.fromString((String)xml, (XSerializable)xSerializableMap);
            Map<K, V> map = mapSupplier.get();
            map.putAll((Map<K, V>)xSerializableMap);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLocaleCheckTemplate(Locale locale) {
        Locale preferredAssistCheckLocale = AssistPGUtils.getPreferredAssistCheckLocale(locale);
        return CHECK_TEMPLATES.get(preferredAssistCheckLocale);
    }

    public static Locale getPreferredAssistCheckLocale(Traveller traveller, BookingFile bookingFile) {
        EntityContainer passengerCtr = EntityStorageHelper.resolve((EntityReference)traveller.getPassenger());
        return AssistPGUtils.getPreferredAssistCheckLocale((Person)passengerCtr.getEntity(), bookingFile);
    }

    private static Locale getPreferredAssistCheckLocale(Locale locale) {
        return !CHECK_TEMPLATES.containsKey(locale) ? DEFAULT_PREFERRED_LOCALE : locale;
    }

    public static Locale getPreferredAssistCheckLocale(Person passenger, BookingFile bookingFile) {
        Locale preferredLocale = passenger.getPreferredAssistCheckLocale();
        if (Objects.nonNull(preferredLocale)) {
            return AssistPGUtils.getPreferredAssistCheckLocale(preferredLocale);
        }
        EntityContainer clientOrgCtr = EntityStorageHelper.resolve((EntityReference)bookingFile.getCustomerProfile());
        if (Objects.isNull(clientOrgCtr)) {
            return AssistPGUtils.getPreferredAssistCheckLocale(preferredLocale);
        }
        Organization clientOrg = (Organization)clientOrgCtr.getEntity();
        preferredLocale = clientOrg.getPreferredAssistCheckLocale();
        if (Objects.nonNull(preferredLocale)) {
            return AssistPGUtils.getPreferredAssistCheckLocale(preferredLocale);
        }
        EntityContainer parentOrgCtr = EntityStorageHelper.resolve((EntityReference)((Organization)clientOrgCtr.getEntity()).getParent());
        if (Objects.nonNull(parentOrgCtr)) {
            preferredLocale = ((Organization)parentOrgCtr.getEntity()).getPreferredAssistCheckLocale();
        }
        return AssistPGUtils.getPreferredAssistCheckLocale(preferredLocale);
    }

    public static Function<? super FopInfo, String> transaction() {
        return fopInfo -> {
            FopType fopType = fopInfo.getFopType();
            if (FopType.PRODUCT == fopType || FopType.PAYMENT == fopType) {
                return FIRST_TRANSACTION;
            }
            return fopInfo.isFopSupplier() ? FIRST_TRANSACTION : SECOND_TRANSACTION;
        };
    }

    public static String toCheck(Map<CheckParameter, String> checkParameters, Locale checkLocale, MessageContext ctx) {
        try {
            String[] parameters = (String[])checkParameters.entrySet().stream().map(Map.Entry::getKey).map(checkParameter -> "<" + checkParameter.origin() + ">").toArray(String[]::new);
            String[] values = (String[])checkParameters.entrySet().stream().map(Map.Entry::getValue).map(str -> WordUtils.wrap((String)str, (int)75)).toArray(String[]::new);
            return StringUtils.replaceEachRepeatedly((String)AssistPGUtils.getLocaleCheckTemplate(checkLocale), (String[])parameters, (String[])values).trim();
        }
        catch (Exception e) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"error while fill check, exception={0}", (Object[])new Object[]{TextUtil.getExceptionStackTrace((Throwable)e)}));
            return null;
        }
    }

    public static Locale getStringLocaleUsingPatterns(String stringSample, boolean defaultRu) {
        Locale stringLocale = null;
        if (CYRILLIC_SYMBOLS_PATTERN.matcher(stringSample).matches()) {
            stringLocale = LocaleUtil.LOCALE_RU;
        }
        if (LATIN_SYMBOLS_PATTERN.matcher(stringSample).matches()) {
            stringLocale = LocaleUtil.LOCALE_EN;
        }
        if (Objects.isNull(stringLocale) && defaultRu) {
            stringLocale = LocaleUtil.LOCALE_RU;
        }
        return stringLocale;
    }

    public static Locale preferredCheckLocale(Payment payment) {
        if (Objects.isNull(payment)) {
            return DEFAULT_PREFERRED_LOCALE;
        }
        String preferredCheckLocaleStr = AssistPGUtils.getValue(payment, PREFERRED_CHECK_LOCALE_KEY);
        if (Objects.isNull(preferredCheckLocaleStr)) {
            return DEFAULT_PREFERRED_LOCALE;
        }
        return Locale.forLanguageTag(preferredCheckLocaleStr);
    }

    private static Stream<MiscUtil.Pair<BaseProduct, GeneralProductFop>> clientFopStream(BookingFile bookingFile) {
        return BookingStreamHelper.baseProductStreamSafe((BookingFile)bookingFile).flatMap(baseProduct -> AssistPGUtils.clientFopStream(CardPaymentUtils.productHandler((BaseProduct)baseProduct).getUnmodifiableContractRelations(baseProduct)).map(generalProductFop -> new MiscUtil.Pair(baseProduct, generalProductFop)));
    }

    private static Stream<GeneralProductFop> clientFopStream(List<GeneralProductContractRelationData> generalProductContractRelationDataList) {
        return generalProductContractRelationDataList.stream().filter(generalProductContractRelationData -> ContractType.CLIENT == GeneralProductHelper.getContractType((EntityReference)generalProductContractRelationData.getDescription())).map(GeneralProductContractRelationData::getFops).flatMap(Collection::stream);
    }

    public static void updateProductAndFops(BookingFile bookingFile, Predicate<? super BaseProduct> productFilter, Consumer<? super BaseProduct> productUpdater, BiPredicate<? super BaseProduct, ? super GeneralProductFop> fopFilter, BiConsumer<? super BaseProduct, ? super GeneralProductFop> fopUpdater) {
        Objects.requireNonNull(bookingFile);
        Objects.requireNonNull(productFilter);
        Objects.requireNonNull(productUpdater);
        Objects.requireNonNull(fopUpdater);
        BookingStreamHelper.baseProductStreamSafe((BookingFile)bookingFile).filter(productFilter).peek(productUpdater).forEach(baseProduct -> AssistPGUtils.updateProductFop(baseProduct, fopFilter, fopUpdater));
    }

    private static void updateProductFop(BaseProduct baseProduct, BiPredicate<? super BaseProduct, ? super GeneralProductFop> fopFilter, BiConsumer<? super BaseProduct, ? super GeneralProductFop> fopUpdater) {
        List generalProductContractRelationDataList = GeneralProductHelper.copyContractRelations((BaseProduct)baseProduct);
        AssistPGUtils.clientFopStream(generalProductContractRelationDataList).filter(generalProductFop -> fopFilter.test((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop)).forEach(generalProductFop -> fopUpdater.accept((BaseProduct)baseProduct, (GeneralProductFop)generalProductFop));
        CardPaymentUtils.productHandler((BaseProduct)baseProduct).updateContractRelations(baseProduct, generalProductContractRelationDataList);
    }

    private static void prepareBookingFileBeforeApplyRules(BookingFile bookingFile, PaymentType paymentType) {
        AssistPGUtils.updateProductAndFops(bookingFile, CardPaymentUtils.checked().negate(), CardPaymentUtils.rulesApplied((boolean)false), Predicates.simpleBiPredicate((boolean)true), (baseProduct, generalProductFop) -> generalProductFop.setType(paymentType));
    }

    private static void correction(List<FopInfo> currentFops, List<FopInfo> previousFops) {
        BigDecimal previousAmount;
        if (Objects.isNull(previousFops)) {
            return;
        }
        Map currentByType = currentFops.stream().collect(Collectors.toMap(FopInfo::getFopType, Function.identity(), (o, o2) -> o2, HashMap::new));
        Map previousByType = previousFops.stream().collect(Collectors.toMap(FopInfo::getFopType, Function.identity(), (o, o2) -> o2, HashMap::new));
        FopInfo currentPaymentFop = (FopInfo)currentByType.get(FopType.PAYMENT);
        FopInfo previousPaymentFop = (FopInfo)previousByType.get(FopType.PAYMENT);
        if (Objects.isNull(currentPaymentFop) || Objects.isNull(previousPaymentFop)) {
            return;
        }
        BigDecimal currentAmount = currentPaymentFop.getAmount();
        if (currentAmount.compareTo(previousAmount = previousPaymentFop.getAmount()) > 0) {
            currentPaymentFop.setAmount(currentAmount.subtract(previousAmount));
        }
    }

    private static void binding(List<FopInfo> fops) {
        Objects.requireNonNull(fops);
        Map byType = fops.stream().collect(Collectors.toMap(FopInfo::getFopType, Function.identity(), (o, o2) -> o2, HashMap::new));
        FopInfo productFop = (FopInfo)byType.get(FopType.PRODUCT);
        FopInfo paymentFop = (FopInfo)byType.get(FopType.PAYMENT);
        if (Objects.nonNull(productFop)) {
            productFop.setRelated(paymentFop);
        }
    }

    private static Map<BaseProduct, List<FopInfo>> unpaidFops(BookingFile bookingFile, PaymentType paymentType, Map<BaseProduct, List<FopInfo>> previousFops) {
        Map<BaseProduct, List<FopInfo>> productFopInfos = AssistPGUtils.clientFopStream(bookingFile).peek(pair -> CardPaymentUtils.modify((BaseProduct)((BaseProduct)pair.getFirst()), (GeneralProductFop)((GeneralProductFop)pair.getSecond()))).filter(pair -> !CardPaymentUtils.isPaid((GeneralProductFop)((GeneralProductFop)pair.getSecond()))).filter(pair -> paymentType == ((GeneralProductFop)pair.getSecond()).getType()).filter(pair -> ((GeneralProductFop)pair.getSecond()).getEquivalentAmount().signum() > 0).collect(Collectors.groupingBy(MiscUtil.Pair::getFirst, Collectors.mapping(pair -> CommonPgFopInfoUtil.toInfo((BaseProduct)((BaseProduct)pair.getFirst()), (GeneralProductFop)((GeneralProductFop)pair.getSecond())), Collectors.toList())));
        productFopInfos.entrySet().stream().filter(entry -> !CardPaymentUtils.productHandler((BaseProduct)((BaseProduct)entry.getKey())).isChecked((BaseProduct)entry.getKey())).peek(entry -> AssistPGUtils.correction((List)entry.getValue(), (List)previousFops.get(entry.getKey()))).forEach(entry -> AssistPGUtils.binding((List)entry.getValue()));
        return productFopInfos;
    }

    public static Map<BaseProduct, List<FopInfo>> unpaidFopsWithApplyRules(EntityContainer<BookingFile> bookingFileCtr, PaymentType paymentType) {
        BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
        Map<BaseProduct, List<FopInfo>> previousFops = AssistPGUtils.unpaidFops(bookingFile, paymentType, Collections.emptyMap());
        AssistPGUtils.prepareBookingFileBeforeApplyRules(bookingFile, paymentType);
        CardPaymentUtils.applyRules(bookingFileCtr);
        return AssistPGUtils.unpaidFops(bookingFile, paymentType, previousFops);
    }

    public static <T, R> Map<R, List<FopInfo>> keyTransformation(Map<T, List<FopInfo>> productFops, Function<T, R> keyMapper) {
        Objects.requireNonNull(productFops);
        Objects.requireNonNull(keyMapper);
        return productFops.entrySet().stream().collect(Collectors.toMap(entry -> keyMapper.apply(entry.getKey()), Map.Entry::getValue));
    }

    public static Map<BaseProduct, List<FopInfo>> restore(BookingFile bookingFile, Payment payment) {
        String clientFopsXml = AssistPGUtils.getValue(payment, CLIENT_FOPS_KEY);
        Map clientFops = AssistPGUtils.fromXmlString(clientFopsXml, HashMap::new);
        return AssistPGUtils.restore(bookingFile, clientFops, Function.identity());
    }

    public static <T> Map<BaseProduct, List<FopInfo>> restore(BookingFile bookingFile, Map<T, List<FopInfo>> productFops, Function<T, String> keyUidMapper) {
        Objects.requireNonNull(bookingFile);
        Objects.requireNonNull(productFops);
        Objects.requireNonNull(keyUidMapper);
        Map uidProductMap = BookingStreamHelper.baseProductStreamSafe((BookingFile)bookingFile).collect(Collectors.toMap(BaseIdentity::getUid, Function.identity()));
        return AssistPGUtils.keyTransformation(productFops, t -> (BaseProduct)uidProductMap.get(keyUidMapper.apply(t)));
    }

    public static <T, A, R> Map<BaseProduct, R> valueTransformation(Map<BaseProduct, List<FopInfo>> productFops, Collector<? super FopInfo, A, R> collector) {
        Objects.requireNonNull(productFops);
        Objects.requireNonNull(collector);
        HashMap productFopMap = new HashMap();
        productFops.forEach((baseProduct, fops) -> {
            Object collect = fops.stream().collect(collector);
            productFopMap.put(baseProduct, collect);
        });
        return productFopMap;
    }

    public static <K, V> Map<BaseProduct, Map<K, V>> valueTransformation(Map<BaseProduct, List<FopInfo>> productFops, Function<? super FopInfo, K> keyMapper, Function<FopInfo, V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        return AssistPGUtils.valueTransformation(productFops, Collectors.toMap(keyMapper, valueMapper));
    }

    public static Map<BaseProduct, Map<String, Pair<FopInfo>>> merge(Map<BaseProduct, List<FopInfo>> source1, Map<BaseProduct, List<FopInfo>> source2) {
        Objects.requireNonNull(source1);
        Objects.requireNonNull(source2);
        Map<BaseProduct, Map<String, Pair<FopInfo>>> productFopMap1 = AssistPGUtils.valueTransformation(source1, FopInfo::getFopId, fopInfo -> new Pair(fopInfo, null));
        Map<BaseProduct, Map<String, Pair>> productFopMap2 = AssistPGUtils.valueTransformation(source2, FopInfo::getFopId, fopInfo -> new Pair(null, fopInfo));
        productFopMap2.forEach((baseProduct, fopMap2) -> {
            Map fopMap1 = (Map)productFopMap1.get(baseProduct);
            if (Objects.isNull(fopMap1)) {
                return;
            }
            fopMap2.forEach((fopId, fopPair2) -> {
                Pair fopPair1 = (Pair)fopMap1.get(fopId);
                if (Objects.isNull(fopPair1)) {
                    fopMap1.put(fopId, fopPair2);
                } else {
                    fopPair1.setLast(fopPair2.getLast());
                }
            });
        });
        return productFopMap1;
    }

    public static void validate(Map<BaseProduct, Map<String, Pair<FopInfo>>> mergeFops) {
        Objects.requireNonNull(mergeFops);
        mergeFops.forEach((baseProduct, pairFopMap) -> pairFopMap.forEach((fopId, pairFop) -> {
            BigDecimal unpaidFopAmount;
            FopInfo selectedFop = (FopInfo)pairFop.getFirst();
            FopInfo unpaidFop = (FopInfo)pairFop.getLast();
            if (Objects.nonNull(selectedFop) && Objects.isNull(unpaidFop)) {
                throw Xeption.forDeveloper((String)"\u0424\u043e\u043f\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438\u0441\u044c", (Object[])new Object[0]);
            }
            String relatedSelectedFopId = CommonPgFopInfoUtil.relatedFopId((FopInfo)selectedFop);
            String relatedUnpaidFopId = CommonPgFopInfoUtil.relatedFopId((FopInfo)unpaidFop);
            if (Objects.isNull(selectedFop) && Objects.nonNull(relatedUnpaidFopId)) {
                throw Xeption.forDeveloper((String)"\u0424\u043e\u043f\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438\u0441\u044c", (Object[])new Object[0]);
            }
            if (!Objects.equals(relatedSelectedFopId, relatedUnpaidFopId)) {
                throw Xeption.forDeveloper((String)"\u0424\u043e\u043f\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438\u0441\u044c", (Object[])new Object[0]);
            }
            if (Objects.nonNull(relatedSelectedFopId) && (!pairFopMap.containsKey(relatedSelectedFopId) || Objects.isNull(((Pair)pairFopMap.get(relatedSelectedFopId)).getFirst()))) {
                throw Xeption.forDeveloper((String)"\u0424\u043e\u043f\u044b \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438\u0441\u044c", (Object[])new Object[0]);
            }
            if (Objects.isNull(selectedFop)) {
                return;
            }
            BigDecimal selectedFopAmount = selectedFop.getAmount();
            if (selectedFopAmount.compareTo(unpaidFopAmount = unpaidFop.getAmount()) != 0) {
                throw Xeption.forDeveloper((String)"\u0426\u0435\u043d\u0430 \u0444\u043e\u043f\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c", (Object[])new Object[0]);
            }
        }));
    }

    public static OrderResultRequest newOrderResultRequest(MerchantSettings merchantSettings, Payment payment, Format format) {
        String orderNumber = NamedValueHelper.getValueForName((String)ORDER_NUMBER_KEY, (Collection)payment.getCustomParameters());
        return new OrderResultRequest(merchantSettings, orderNumber, payment.getPaymentDate(), format);
    }

    static {
        try {
            CHECK_TEMPLATES.put(LocaleUtil.LOCALE_RU, (String)AssistPGUtils.resourceHandler("checkTemplate.txt", inputStream -> IOUtils.toString((Reader)inputStream)));
            CHECK_TEMPLATES.put(DEFAULT_PREFERRED_LOCALE, CHECK_TEMPLATES.get(LocaleUtil.LOCALE_RU));
            CHECK_TEMPLATES.put(LocaleUtil.LOCALE_EN, (String)AssistPGUtils.resourceHandler("checkTemplate_en.txt", inputStream -> IOUtils.toString((Reader)inputStream)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

