/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AssistPaymentInitiationParametersBuilder {
    private final PaymentInitiationParameters parameters = new PaymentInitiationParameters();

    public AssistPaymentInitiationParametersBuilder(Payment payment, SalesContext salesContext, String returnUrl, String successUrl, String errorUrl) {
        this.parameters.setPg(PgName.ASSIST);
        this.parameters.setPayment(payment);
        this.parameters.setSalesContext(salesContext);
        this.parameters.setReturnUrl(returnUrl);
        this.parameters.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.SUCCESS_URL_SITE_KEY, (String)successUrl));
        this.parameters.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.ERROR_URL_SITE_KEY, (String)errorUrl));
        this.parameters.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.RETURN_DOMAIN_URL_SITE_KEY, (String)returnUrl));
    }

    public AssistPaymentInitiationParametersBuilder newSite(boolean newSite) {
        this.parameters.setNewSite(newSite);
        return this;
    }

    public AssistPaymentInitiationParametersBuilder dontDoReprice(boolean dontDoReprice) {
        this.parameters.setDontDoReprice(dontDoReprice);
        return this;
    }

    public PaymentInitiationParameters build() throws RuntimeException {
        this.validate();
        this.updatePayment();
        try {
            return (PaymentInitiationParameters)XCloneHelper.clone((XCloneable)this.parameters, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updatePayment() {
        Payment payment = this.parameters.getPayment();
        Set<String> urlKeys = AssistPaymentInitiationParametersBuilder.urlKeys();
        payment.getCustomParameters().removeIf(namedValue -> {
            if (Objects.isNull(namedValue)) {
                return false;
            }
            return urlKeys.contains(namedValue.getName());
        });
        urlKeys.forEach(urlKey -> {
            NamedValue namedValue = NamedValueHelper.getNamedValueForName((String)urlKey, (Collection)this.parameters.getCustomParameters());
            Objects.requireNonNull(namedValue);
            payment.getCustomParameters().add(namedValue);
        });
    }

    private static Set<String> urlKeys() {
        HashSet<String> urlKeys = new HashSet<String>();
        urlKeys.add(AssistPGUtils.RETURN_DOMAIN_URL_SITE_KEY);
        urlKeys.add(AssistPGUtils.SUCCESS_URL_SITE_KEY);
        urlKeys.add(AssistPGUtils.ERROR_URL_SITE_KEY);
        return urlKeys;
    }

    private void validate() throws RuntimeException {
        Objects.requireNonNull(this.parameters, "null parameters");
        Objects.requireNonNull(this.parameters.getPg());
        if (PgName.ASSIST != this.parameters.getPg()) {
            throw new IllegalStateException("not " + PgName.ASSIST.name());
        }
        Objects.requireNonNull(this.parameters.getPayment());
        Objects.requireNonNull(this.parameters.getSalesContext());
        Objects.requireNonNull(this.parameters.getReturnUrl());
        List customParameters = this.parameters.getCustomParameters();
        Set<String> urlKeys = AssistPaymentInitiationParametersBuilder.urlKeys();
        urlKeys.stream().map(urlKey -> NamedValueHelper.getValueForName((String)urlKey, (Collection)customParameters)).forEach(Objects::requireNonNull);
    }
}

