/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.CardPaymentStrategy;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PgPaymentBuilder;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.card.CardPaymentUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class AssistPgPaymentBuilder
extends PgPaymentBuilder<AssistPgPaymentBuilder> {
    protected Map<BaseProduct, List<FopInfo>> clientFops;
    protected CardPaymentStrategy cardPaymentStrategy = CardPaymentStrategy.STANDARD;
    protected String transaction;

    public AssistPgPaymentBuilder setClientFops(Map<BaseProduct, List<FopInfo>> clientFops) {
        this.clientFops = clientFops;
        return this;
    }

    public AssistPgPaymentBuilder setCardPaymentStrategy(CardPaymentStrategy cardPaymentStrategy) {
        this.cardPaymentStrategy = cardPaymentStrategy;
        return this;
    }

    public AssistPgPaymentBuilder setTransaction(String transaction) {
        this.transaction = transaction;
        return this;
    }

    private BigDecimal calculateAmount() {
        if (Objects.nonNull(this.amount)) {
            return this.amount;
        }
        if (Objects.nonNull(this.clientFops)) {
            return this.clientFops.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).map(FopInfo::getAmount).reduce(BigDecimal::add).filter(sum -> sum.compareTo(BigDecimal.ZERO) > 0).orElseThrow(() -> Xeption.forDeveloper((String)"\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b", (Object[])new Object[0]));
        }
        try {
            BigDecimal orderPrice = AssistPGUtils.orderPrice((EntityContainer<BookingFile>)this.bookingFileCtr, this.paymentType, this.card);
            return Objects.requireNonNull(orderPrice, "null orderPrice");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void internalPrepare() {
        String orderNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)this.bookingFileCtr.getEntity())) + "/" + UUID.randomUUID().toString();
        this.addCustomParameter(NamedValueHelper.namedValue((String)AssistPGUtils.ORDER_NUMBER_KEY, (String)orderNumber));
        this.addCustomParameter(NamedValueHelper.namedValue((String)CardPaymentUtils.STRATEGY_KEY, (String)this.cardPaymentStrategy.name()));
        if (Objects.nonNull(this.transaction)) {
            this.addCustomParameter(NamedValueHelper.namedValue((String)AssistPGUtils.TRANSACTION_KEY, (String)this.transaction));
        }
        if (Objects.nonNull(this.clientFops)) {
            Map<String, List<FopInfo>> clientFops = AssistPGUtils.keyTransformation(this.clientFops, BaseIdentity::getUid);
            String xml = AssistPGUtils.toXmlString(clientFops);
            this.addCustomParameter(NamedValueHelper.namedValue((String)AssistPGUtils.CLIENT_FOPS_KEY, (String)xml));
        }
    }

    public Payment build() {
        this.amount = this.calculateAmount().setScale(2, RoundingMode.HALF_UP);
        this.internalPrepare();
        Payment payment = super.build();
        PgName pgName = PgName.ASSIST;
        payment.setPg(pgName);
        PGConnector pgConnector = PGConnectorRegistry.get().get(pgName);
        PGConnectorInfo connectorInfo = pgConnector.getConnectorInfo();
        List supportedPaymentTypes = connectorInfo.getSupportedPaymentTypes();
        PaymentType paymentType = payment.getPaymentType();
        if (!supportedPaymentTypes.contains(paymentType)) {
            throw new IllegalStateException(String.format("PaymentType=[%s] not supported", paymentType.name()));
        }
        return payment;
    }
}

