/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.InvokeWebMethod;
import com.gridnine.xtrip.server.pg.assist.WebMethod;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultRequest;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultResponse;
import com.gridnine.xtrip.server.pg.assist.model.Parameter;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderResult
implements WebMethod,
InvokeWebMethod<OrderResultRequest, OrderResultResponse> {
    private static final Logger log = LoggerFactory.getLogger(OrderResult.class);
    static final Set<Format> SUPPORTED_FORMAT = Collections.unmodifiableSet(EnumSet.of(Format.XML));

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public String uri() {
        return "/orderresult/orderresult.cfm";
    }

    @Override
    public OrderResultResponse invoke(OrderResultRequest request) throws Exception {
        Date startDate = new Date();
        EnumMap<Parameter, String> parameters = null;
        String response = null;
        OrderResultResponse orderResultResponse = null;
        try {
            Objects.requireNonNull(request, "no OrderResultRequest");
            if (!SUPPORTED_FORMAT.contains((Object)request.getFormat())) {
                throw new IllegalStateException(String.format("format=[%s] not supported", EnumUtil.nameOf((Enum)request.getFormat())));
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpPost httpRequestBase;
                parameters = new EnumMap<Parameter, String>(Parameter.class);
                MerchantSettings merchantSettings = request.getMerchantSettings();
                parameters.put(Parameter.MERCHANT_ID, merchantSettings.getId());
                parameters.put(Parameter.LOGIN, merchantSettings.getLogin());
                parameters.put(Parameter.PASSWORD, merchantSettings.getPassword());
                parameters.put(Parameter.ORDER_NUMBER, request.getOrderNumber());
                parameters.put(Parameter.FORMAT, request.getFormat().value());
                String url = this.buildUrl();
                switch (this.method()) {
                    case "POST": {
                        List<NameValuePair> nameValuePairList = AssistPGUtils.toNameValuePairs(parameters);
                        HttpPost httpPost = new HttpPost(url);
                        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairList));
                        httpRequestBase = httpPost;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("not supported method=" + this.method());
                    }
                }
                try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequestBase);){
                    response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
                    orderResultResponse = OrderResultResponse.newInstance(IOUtils.toInputStream((String)response));
                }
            }
            PGInvocationContext.get().addTraceData(startDate, InvocationName.GET_PAYMENT_INFO.toString(), parameters, (Object)response, null);
            return orderResultResponse;
        }
        catch (Throwable t) {
            log.error(this.uri(), t);
            PGInvocationContext.get().addTraceData(startDate, InvocationName.GET_PAYMENT_INFO.toString(), parameters, response, t);
            throw t;
        }
    }
}

