/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.RedirectForm;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.PayOrderResult;
import com.gridnine.xtrip.server.pg.assist.WebMethod;
import com.gridnine.xtrip.server.pg.assist.model.AssistPaymentType;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.assist.model.Parameter;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;

final class PayOrder
implements WebMethod {
    private final MerchantSettings merchantSettings;

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public String uri() {
        return "/pay/order.cfm";
    }

    PayOrder(MerchantSettings merchantSettings) throws NullPointerException {
        this.merchantSettings = Objects.requireNonNull(merchantSettings, "no MerchantSettings");
    }

    void initiationPayment(PaymentInitiationParameters initiationParameters, PaymentInitiationResult initiationResult) throws Exception {
        Objects.requireNonNull(initiationParameters, "no PaymentInitiationParameters");
        Objects.requireNonNull(initiationResult, "no PaymentInitiationResult");
        RedirectForm redirectForm = initiationResult.getRedirectForm();
        Payment payment = initiationParameters.getPayment();
        redirectForm.setMethod(this.method());
        redirectForm.setUrl(this.buildUrl());
        EnumMap<Parameter, String> body = new EnumMap<Parameter, String>(Parameter.class);
        body.put(Parameter.MERCHANT_ID, this.merchantSettings.getId());
        body.put(Parameter.ORDER_NUMBER, payment.getPaymentId());
        body.put(Parameter.ORDER_AMOUNT, AssistPGUtils.PRICE_FORMAT.get().format(payment.getAmount()));
        Arrays.stream(AssistPaymentType.values()).forEach(paymentType -> body.put(paymentType.parameter(), "0"));
        AssistPaymentType paymentType2 = AssistPaymentType.valueOf(payment.getPaymentType());
        Objects.requireNonNull(paymentType2, "no payment type for " + EnumUtil.nameOf((Enum)payment.getPaymentType()));
        body.put(paymentType2.parameter(), "1");
        body.put(Parameter.URL_RETURN_OK, PayOrderResult.buildUrl(initiationParameters.getReturnUrl(), 1));
        body.put(Parameter.URL_RETURN_NO, PayOrderResult.buildUrl(initiationParameters.getReturnUrl(), 0));
        body.entrySet().stream().filter(Objects::nonNull).map(entry -> NamedValueHelper.namedValue((String)((Parameter)((Object)((Object)entry.getKey()))).origin(), (String)((String)entry.getValue()))).filter(Objects::nonNull).forEach(redirectForm.getParameters()::add);
    }
}

