/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

final class PayOrderResult {
    private final String billNumber;
    private final String orderNumber;
    private final int status;
    static final int STATUS_OK = 1;
    static final int STATUS_ERROR = 0;
    static final String URL = "/assist/payOrder";

    static final String buildUrl(String uri, int status) throws URISyntaxException {
        Objects.requireNonNull(uri, "no host");
        return new URIBuilder(uri).setPath(URL).addParameter(Parameter.STATUS.origin(), Integer.toString(status)).build().toString();
    }

    private PayOrderResult(Builder builder) throws NullPointerException, IllegalStateException {
        Objects.requireNonNull(builder, "no Builder");
        Objects.requireNonNull(builder.status, "empty status");
        this.status = builder.status;
        switch (builder.status) {
            case 1: {
                this.orderNumber = Objects.requireNonNull(builder.orderNumber, "no OrderNumber");
                this.billNumber = Objects.requireNonNull(builder.billNumber, "no BillNumber");
                break;
            }
            case 0: {
                this.orderNumber = null;
                this.billNumber = null;
                break;
            }
            default: {
                throw new IllegalStateException("unknown status=" + builder.status);
            }
        }
    }

    static PayOrderResult newInstance(Map<String, String[]> parameters) throws NullPointerException {
        Objects.requireNonNull(parameters, "no parameters");
        Builder builder = new Builder();
        builder.setStatus(TextUtil.toInteger((String)MiscUtil.getValue((String[])parameters.get(Parameter.STATUS.origin()), (int)0)));
        builder.setBillNumber(MiscUtil.getValue((String[])parameters.get(Parameter.BILL_NUMBER.origin()), (int)0));
        builder.setOrderNumber(MiscUtil.getValue((String[])parameters.get(Parameter.ORDER_NUMBER.origin()), (int)0));
        return builder.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PayOrderResult)) {
            return false;
        }
        PayOrderResult other = (PayOrderResult)obj;
        return this.status == other.status && TextUtil.equals((String)this.billNumber, (String)other.billNumber, (boolean)true) && TextUtil.equals((String)this.orderNumber, (String)other.billNumber, (boolean)true);
    }

    public int hashCode() {
        int res = 31;
        res = 31 * res + this.status;
        res = 31 * res + MiscUtil.hashCode((Object)this.billNumber);
        res = 31 * res + MiscUtil.hashCode((Object)this.orderNumber);
        return res;
    }

    public String toString() {
        return String.format("PayOrderResult{status=[%s], billNumber=[%s], orderNumber=[%s]}", this.status, this.billNumber, this.orderNumber);
    }

    String getBillNumber() {
        return this.billNumber;
    }

    String getOrderNumber() {
        return this.orderNumber;
    }

    int getStatus() {
        return this.status;
    }

    private static final class Builder {
        private String billNumber;
        private String orderNumber;
        private Integer status;

        public Builder setBillNumber(String billNumber) {
            this.billNumber = billNumber;
            return this;
        }

        public Builder setOrderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public Builder setStatus(Integer status) {
            this.status = status;
            return this;
        }

        public PayOrderResult build() {
            return new PayOrderResult(this);
        }
    }

    static enum Parameter {
        STATUS("status"),
        BILL_NUMBER("billnumber"),
        ORDER_NUMBER("ordernumber");

        private final String origin;

        private Parameter(String origin) {
            this.origin = Objects.requireNonNull(origin, "no origin");
        }

        public String origin() {
            return this.origin;
        }
    }
}

