/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.pg.helpers.CommonPgFopInfoUtil;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.AssistPaymentScheme;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PaymentInfo {
    private static final BookingFile UNDEFINED_BF = new BookingFile();
    private static final Organization UNDEFINED_ORG = new Organization();
    private final Payment payment;
    private BookingFile bookingFile = UNDEFINED_BF;
    private Organization payee = UNDEFINED_ORG;
    private Organization payer = UNDEFINED_ORG;
    private Map<BaseProduct, List<FopComponent>> fopComponents;

    public PaymentInfo(Payment payment) {
        this.payment = payment;
    }

    public Payment getPayment() {
        return this.payment;
    }

    public BookingFile getBookingFile() {
        if (this.bookingFile == UNDEFINED_BF) {
            EntityReference ref = this.payment.getEntity();
            EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)ref);
            this.bookingFile = ctr != null ? (BookingFile)ctr.getEntity() : null;
        }
        return this.bookingFile;
    }

    public Organization getPayee() {
        if (this.payee == UNDEFINED_ORG) {
            EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)this.payment.getPayee());
            this.payee = ctr != null ? (Organization)ctr.getEntity() : null;
        }
        return this.payee;
    }

    public Organization getPayer() {
        if (this.payer == UNDEFINED_ORG) {
            EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)this.payment.getPayer());
            this.payer = ctr != null ? (Organization)ctr.getEntity() : null;
        }
        return this.payer;
    }

    public Map<BaseProduct, List<FopComponent>> getFopComponents() {
        if (this.fopComponents == null) {
            BookingFile bookingFile = this.getBookingFile();
            if (AssistPGUtils.scheme(this.payment) == AssistPaymentScheme.CLIENT_FOPS) {
                Map<BaseProduct, List<FopInfo>> paymentFops = AssistPGUtils.restore(bookingFile, this.payment);
                this.fopComponents = paymentFops.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, productEntry -> ((List)productEntry.getValue()).stream().map(info -> CommonPgFopInfoUtil.toFop((BaseProduct)((BaseProduct)productEntry.getKey()), (FopInfo)info)).flatMap(fop -> {
                    String fopUid = fop.getUid();
                    if (fop == null) {
                        throw Xeption.forDeveloper((String)"GeneralProductFop value is null", (Object[])new Object[0]);
                    }
                    BaseProduct product = (BaseProduct)productEntry.getKey();
                    FopDetalization fopDetalization = (FopDetalization)product.getFopDetalizations().get(fopUid);
                    if (fopDetalization == null) {
                        throw Xeption.forDeveloper((String)"fop detalization is not found", (Object[])new Object[0]);
                    }
                    return fopDetalization.getComponents().stream();
                }).collect(Collectors.toList())));
            } else {
                this.fopComponents = BookingHelper.getBaseProductsStream((BookingFile)bookingFile).collect(Collectors.toMap(Function.identity(), p -> GeneralProductHelper.getClientFops((BaseProduct)p).stream().flatMap(f -> ((FopDetalization)p.getFopDetalizations().get(f.getUid())).getComponents().stream()).collect(Collectors.toList())));
            }
        }
        return this.fopComponents;
    }
}

