/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.server.pg.assist.BaseSilentPayFormatHandler;
import com.gridnine.xtrip.server.pg.assist.InvokeWebMethod;
import com.gridnine.xtrip.server.pg.assist.SilentPayRequest;
import com.gridnine.xtrip.server.pg.assist.SilentPayResponse;
import com.gridnine.xtrip.server.pg.assist.SilentPaySoapFormatHandler;
import com.gridnine.xtrip.server.pg.assist.SilentPayXmlFormatHandler;
import com.gridnine.xtrip.server.pg.assist.WebMethod;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

final class SilentPay
implements WebMethod,
InvokeWebMethod<SilentPayRequest, SilentPayResponse> {
    private static final Map<Format, BaseSilentPayFormatHandler<?, ?>> supportedFormats;

    SilentPay() {
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public String uri() {
        return "/pay/silentpay.cfm";
    }

    static void register(Map<Format, BaseSilentPayFormatHandler<?, ?>> formatHandlers, BaseSilentPayFormatHandler<?, ?> baseSilentPayFormatHandler) {
        Format format = baseSilentPayFormatHandler.format();
        BaseSilentPayFormatHandler<?, ?> previousHandler = formatHandlers.put(format, baseSilentPayFormatHandler);
        if (Objects.nonNull(previousHandler)) {
            throw Xeption.forDeveloper((String)"already register {0}", (Object[])new Object[]{previousHandler.getClass().getName()});
        }
    }

    @Override
    public SilentPayResponse invoke(SilentPayRequest request) throws Exception {
        Objects.requireNonNull(request);
        Format format = request.getFormat();
        BaseSilentPayFormatHandler<?, ?> formatHandler = supportedFormats.get((Object)format);
        if (Objects.isNull(formatHandler)) {
            throw new IllegalArgumentException("don't support format " + format.name());
        }
        SilentPayResponse response = (SilentPayResponse)formatHandler.handle(request);
        return response;
    }

    public static CardTransactionDetails toCardTransactionDetails(Card card, SilentPayResponse response) {
        Objects.requireNonNull(card);
        Objects.requireNonNull(response);
        CardTransactionDetails cardTransactionDetails = new CardTransactionDetails();
        cardTransactionDetails.setNumber(card.getNumber());
        cardTransactionDetails.setNameOnCard(card.getNameOnCard());
        cardTransactionDetails.setExpiration(card.getExpiration());
        cardTransactionDetails.setVendor(card.getVendor());
        cardTransactionDetails.setSecurityCode(response.getApproveCode());
        cardTransactionDetails.setTransactionCode(response.getTransactionCode());
        return cardTransactionDetails;
    }

    static {
        EnumMap formatHandlers = new EnumMap(Format.class);
        SilentPay.register(formatHandlers, new SilentPaySoapFormatHandler());
        SilentPay.register(formatHandlers, new SilentPayXmlFormatHandler());
        supportedFormats = Collections.unmodifiableMap(formatHandlers);
    }
}

