/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.CirToken;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.handlers.InvoiceLineComposer;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.card.CardPaymentUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

final class SilentPayRequest {
    static final Pattern LATIN_SYMBOLS_PATTERN = Pattern.compile("^[a-zA-Z-]+$");
    static final Pattern CYRILLIC_SYMBOLS_PATTERN = Pattern.compile("^[\u0430-\u044f\u0410-\u042f-]+$");
    private static final String LASTNAME_KEY = "LASTNAME_KEY";
    private static final String FIRSTNAME_KEY = "FIRSTNAME_KEY";
    private final String merchantId;
    private final String login;
    private final String password;
    private final String orderNumber;
    private final BigDecimal orderAmount;
    private final String cardNumber;
    private final String cardHolder;
    private final String expireMonth;
    private final String expireYear;
    private final String lastName;
    private final String firstName;
    private final String email;
    private final Format format;
    private final String cirToken;
    private final String orderComment;

    private SilentPayRequest(Builder builder) throws NullPointerException {
        Objects.requireNonNull(builder);
        this.merchantId = Objects.requireNonNull(builder.merchantId);
        this.login = Objects.requireNonNull(builder.login);
        this.password = Objects.requireNonNull(builder.password);
        this.orderNumber = Objects.requireNonNull(builder.orderNumber);
        this.orderAmount = Objects.requireNonNull(builder.orderAmount);
        this.orderComment = Objects.requireNonNull(builder.orderComment);
        this.cardNumber = Objects.requireNonNull(builder.cardNumber);
        this.cardHolder = Objects.requireNonNull(builder.cardHolder);
        this.expireMonth = Objects.requireNonNull(builder.expireMonth);
        this.expireYear = Objects.requireNonNull(builder.expireYear);
        this.lastName = Objects.requireNonNull(builder.lastName);
        this.firstName = Objects.requireNonNull(builder.firstName);
        this.email = Objects.requireNonNull(builder.email);
        this.format = Objects.requireNonNull(builder.format);
        this.cirToken = Objects.requireNonNull(builder.cirToken);
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public BigDecimal getOrderAmount() {
        return this.orderAmount;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getCardHolder() {
        return this.cardHolder;
    }

    public String getExpireMonth() {
        return this.expireMonth;
    }

    public String getExpireYear() {
        return this.expireYear;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getEmail() {
        return this.email;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getCirToken() {
        return this.cirToken;
    }

    public String getOrderComment() {
        return this.orderComment;
    }

    private static Map<String, String> getLocalizedNames(Person passenger, Locale locale) {
        Passport localePassport;
        String firstName;
        Passport localePassport2;
        if (Objects.isNull(passenger)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> names = new HashMap<String, String>();
        String lastName = (String)passenger.getLastName().getValues().get(locale);
        if (Objects.isNull(lastName) && Objects.nonNull(localePassport2 = (Passport)passenger.getPassports().stream().filter(Objects::nonNull).filter(passport -> {
            if (locale.equals(LocaleHelper.EN_LOCALE)) {
                return LATIN_SYMBOLS_PATTERN.matcher(passport.getLastName()).matches();
            }
            return CYRILLIC_SYMBOLS_PATTERN.matcher(passport.getLastName()).matches();
        }).findFirst().orElse(null))) {
            lastName = localePassport2.getLastName();
        }
        if (Objects.isNull(lastName)) {
            StringBuilder lastNameStrBuilder = new StringBuilder();
            Collection lastNameValues = passenger.getLastName().getValues().values();
            lastNameValues.stream().filter(Objects::nonNull).limit(1L).forEach(foundString -> lastNameStrBuilder.append(TextUtil.translit((String)foundString, (!LocaleHelper.EN_LOCALE.equals(locale) ? 1 : 0) != 0)));
            if (lastNameStrBuilder.length() > 0) {
                lastName = lastNameStrBuilder.toString();
            }
        }
        if (Objects.nonNull(lastName)) {
            names.put(LASTNAME_KEY, lastName);
        }
        if (Objects.isNull(firstName = (String)passenger.getFirstName().getValues().get(locale)) && Objects.nonNull(localePassport = (Passport)passenger.getPassports().stream().filter(Objects::nonNull).filter(passport -> {
            if (locale.equals(LocaleHelper.EN_LOCALE)) {
                return LATIN_SYMBOLS_PATTERN.matcher(passport.getFirstName()).matches();
            }
            return CYRILLIC_SYMBOLS_PATTERN.matcher(passport.getFirstName()).matches();
        }).findFirst().orElse(null))) {
            firstName = localePassport.getFirstName();
        }
        if (Objects.isNull(firstName)) {
            StringBuilder firstNameStrBuilder = new StringBuilder();
            Collection firstNameValues = passenger.getFirstName().getValues().values();
            firstNameValues.stream().filter(Objects::nonNull).limit(1L).forEach(foundString -> firstNameStrBuilder.append(TextUtil.translit((String)foundString, (!LocaleHelper.EN_LOCALE.equals(locale) ? 1 : 0) != 0)));
            if (firstNameStrBuilder.length() > 0) {
                firstName = firstNameStrBuilder.toString();
            }
        }
        if (Objects.nonNull(firstName)) {
            names.put(FIRSTNAME_KEY, firstName);
        }
        return names;
    }

    public static Builder newBuilder(MerchantSettings merchantSettings, BookingFile bookingFile, Payment payment, Card card, Traveller traveller, Locale preferredLocale) {
        Objects.requireNonNull(merchantSettings);
        Objects.requireNonNull(bookingFile);
        Objects.requireNonNull(payment);
        Objects.requireNonNull(card);
        Objects.requireNonNull(traveller);
        Objects.requireNonNull(preferredLocale);
        Calendar cardExpiration = Calendar.getInstance();
        cardExpiration.setTime(card.getExpiration());
        int expireMonth = cardExpiration.get(2) + 1;
        int expireYear = cardExpiration.get(1);
        Passport travellerPassport = traveller.getPassport();
        if (Objects.isNull(travellerPassport)) {
            throw Xeption.forEndUser((String)"ASSIST_NO_TRAVELLER_PASSPORT", (Object[])new Object[0]);
        }
        String lastName = StringUtils.capitalize((String)travellerPassport.getLastName());
        if (Objects.isNull(lastName)) {
            throw Xeption.forEndUser((String)"ASSIST_NO_TRAVELLER_PASSPORT_LAST_NAME", (Object[])new Object[0]);
        }
        String firstName = StringUtils.capitalize((String)travellerPassport.getFirstName());
        if (Objects.isNull(firstName)) {
            throw Xeption.forEndUser((String)"ASSIST_NO_TRAVELLER_PASSPORT_FIRST_NAME", (Object[])new Object[0]);
        }
        String email = "vpos@carlsonwagonlit.ru";
        EntityContainer passengerCtr = EntityStorageHelper.resolve((EntityReference)traveller.getPassenger());
        Person passenger = (Person)passengerCtr.getEntity();
        CirToken cirToken = CirHelper.cirToken((Person)passenger);
        Map<Object, Object> localizedNames = new HashMap();
        if (preferredLocale.equals(LocaleHelper.EN_LOCALE)) {
            if (!LATIN_SYMBOLS_PATTERN.matcher(lastName).matches() || !LATIN_SYMBOLS_PATTERN.matcher(firstName).matches()) {
                localizedNames = SilentPayRequest.getLocalizedNames(passenger, preferredLocale);
            }
        } else if (!(!preferredLocale.equals(LocaleHelper.RU_LOCALE) || CYRILLIC_SYMBOLS_PATTERN.matcher(lastName).matches() && CYRILLIC_SYMBOLS_PATTERN.matcher(firstName).matches())) {
            localizedNames = SilentPayRequest.getLocalizedNames(passenger, preferredLocale);
        }
        String orderNumber = NamedValueHelper.getValueForName((String)AssistPGUtils.ORDER_NUMBER_KEY, (Collection)payment.getCustomParameters());
        return new Builder().setMerchantId(merchantSettings.getId()).setLogin(merchantSettings.getLogin()).setPassword(merchantSettings.getPassword()).setOrderNumber(orderNumber).setOrderAmount(payment.getAmount()).tryExtractOrderComment(payment.getCustomParameters(), InvoiceLineComposer.getInstance().buildComment(bookingFile, preferredLocale)).setCardNumber("{uid:" + card.getCirUid() + "}").setCardHolder(card.getNameOnCard()).setExpireMonth(Integer.toString(expireMonth)).setExpireYear(Integer.toString(expireYear)).setLastName(Objects.nonNull(localizedNames.get(LASTNAME_KEY)) ? (String)localizedNames.get(LASTNAME_KEY) : lastName).setFirstName(Objects.nonNull(localizedNames.get(FIRSTNAME_KEY)) ? (String)localizedNames.get(FIRSTNAME_KEY) : firstName).setEmail(email).setCirToken(cirToken.getTokenData());
    }

    public static class Builder {
        private String merchantId;
        private String login;
        private String password;
        private String orderNumber;
        private BigDecimal orderAmount;
        private String orderComment;
        private String cardNumber;
        private String cardHolder;
        private String expireMonth;
        private String expireYear;
        private String lastName;
        private String firstName;
        private String email;
        private Format format;
        private String cirToken;

        public Builder setMerchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setOrderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            return this;
        }

        public Builder setOrderAmount(BigDecimal orderAmount) {
            this.orderAmount = orderAmount;
            return this;
        }

        public Builder setCardNumber(String cardNumber) {
            this.cardNumber = cardNumber;
            return this;
        }

        public Builder setCardHolder(String cardHolder) {
            this.cardHolder = cardHolder;
            return this;
        }

        public Builder setExpireMonth(String expireMonth) {
            this.expireMonth = expireMonth;
            return this;
        }

        public Builder setExpireYear(String expireYear) {
            this.expireYear = expireYear;
            return this;
        }

        public Builder setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder setFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder setCirToken(String cirToken) {
            this.cirToken = cirToken;
            return this;
        }

        public Builder tryExtractOrderComment(List<NamedValue> list, String defaultVal) {
            String comment = NamedValueHelper.getValueForName((String)CardPaymentUtils.DESCRIPTION_KEY, list);
            this.orderComment = TextUtil.nonBlank((String)comment) ? comment : defaultVal;
            return this;
        }

        public SilentPayRequest build() {
            return new SilentPayRequest(this);
        }
    }
}

