/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.JiBXWSInvoker;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import com.gridnine.xtrip.server.jibxws.WsResponse;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.BaseSilentPayFormatHandler;
import com.gridnine.xtrip.server.pg.assist.SilentPayRequest;
import com.gridnine.xtrip.server.pg.assist.SilentPayResponse;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.silentpay.soap.Result;
import com.gridnine.xtrip.server.pg.assist.model.silentpay.soap.SilentPay;

final class SilentPaySoapFormatHandler
implements BaseSilentPayFormatHandler<SilentPay, Result> {
    private final com.gridnine.xtrip.server.pg.assist.SilentPay silentPay = new com.gridnine.xtrip.server.pg.assist.SilentPay();

    SilentPaySoapFormatHandler() {
    }

    @Override
    public Format format() {
        return Format.SOAP;
    }

    @Override
    public com.gridnine.xtrip.server.pg.assist.SilentPay webMethod() {
        return this.silentPay;
    }

    @Override
    public SilentPay toRequest(SilentPayRequest parameters) {
        SilentPay request = new SilentPay();
        request.setMerchantId(parameters.getMerchantId());
        request.setLogin(parameters.getLogin());
        request.setPassword(parameters.getPassword());
        request.setOrdernumber(parameters.getOrderNumber());
        request.setOrderamount(AssistPGUtils.PRICE_FORMAT.get().format(parameters.getOrderAmount()));
        request.setCardnumber(parameters.getCardNumber());
        request.setCardholder(parameters.getCardHolder());
        request.setExpiremonth(parameters.getExpireMonth());
        request.setExpireyear(parameters.getExpireYear());
        request.setFirstname(parameters.getFirstName());
        request.setLastname(parameters.getLastName());
        request.setEmail(parameters.getEmail());
        return request;
    }

    @Override
    public SilentPayResponse toResult(Result response) {
        return null;
    }

    @Override
    public SilentPayResponse handle(SilentPayRequest parameters) throws Exception {
        SilentPay silentPayRequest = this.toRequest(parameters);
        Format format = this.format();
        com.gridnine.xtrip.server.pg.assist.SilentPay webMethod = this.webMethod();
        WsRequest wsRequest = new WsRequest();
        wsRequest.setPayload((Object)silentPayRequest);
        wsRequest.setEndpointAddress(webMethod.buildUrl() + "?format=" + format.value());
        MessageContext messageContext = new MessageContext();
        messageContext.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, (Object)wsRequest);
        JiBXWSInvoker jiBXWSInvoker = new JiBXWSInvoker(){

            public void process(MessageContext ctx) throws Exception {
                Result fakeSilentPayWsResponse = new Result();
                fakeSilentPayWsResponse.setResponsecode("AS000");
                fakeSilentPayWsResponse.setApprovalcode("789456123");
                WsResponse wsResponse = new WsResponse();
                wsResponse.setPayload((Object)fakeSilentPayWsResponse);
                ctx.putObject((Enum)IBusJibxWsContextKeys.WS_RESPONSE, (Object)wsResponse);
            }
        };
        jiBXWSInvoker.process(messageContext);
        WsResponse wsResponse = (WsResponse)messageContext.getObject((Enum)IBusJibxWsContextKeys.WS_RESPONSE);
        Result result = (Result)wsResponse.getPayload();
        return this.toResult(result);
    }
}

