/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.jibx.JiBXHelper;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.BaseSilentPayFormatHandler;
import com.gridnine.xtrip.server.pg.assist.SilentPay;
import com.gridnine.xtrip.server.pg.assist.SilentPayRequest;
import com.gridnine.xtrip.server.pg.assist.SilentPayResponse;
import com.gridnine.xtrip.server.pg.assist.model.CheckParameter;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.Parameter;
import com.gridnine.xtrip.server.pg.assist.model.silentpay.xml.Order;
import com.gridnine.xtrip.server.pg.assist.model.silentpay.xml.Result;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

final class SilentPayXmlFormatHandler
implements BaseSilentPayFormatHandler<Map<Parameter, String>, Result> {
    private Map<String, String> errorCodeMessageMap = new HashMap<String, String>();
    private final SilentPay silentPay;

    SilentPayXmlFormatHandler() {
        this.errorCodeMessageMap.put("4:106", "THE_CARD_NUMBER_OR_EXPIRATION_DATE_WAS_ENTERED_INCORRECTLY");
        this.errorCodeMessageMap.put("AS100", "THE_CARD_NUMBER_OR_EXPIRATION_DATE_WAS_ENTERED_INCORRECTLY");
        this.errorCodeMessageMap.put("AS102", "INSUFFICIENT_BALANCE");
        this.silentPay = new SilentPay();
    }

    @Override
    public Format format() {
        return Format.XML;
    }

    @Override
    public SilentPay webMethod() {
        return this.silentPay;
    }

    @Override
    public Map<Parameter, String> toRequest(SilentPayRequest parameters) {
        Objects.requireNonNull(parameters);
        EnumMap<Parameter, String> requestMap = new EnumMap<Parameter, String>(Parameter.class);
        requestMap.put(Parameter.MERCHANT_ID, parameters.getMerchantId());
        requestMap.put(Parameter.LOGIN, parameters.getLogin());
        requestMap.put(Parameter.PASSWORD, parameters.getPassword());
        requestMap.put(Parameter.ORDER_NUMBER, parameters.getOrderNumber());
        requestMap.put(Parameter.ORDER_AMOUNT, AssistPGUtils.PRICE_FORMAT.get().format(parameters.getOrderAmount()));
        requestMap.put(Parameter.ORDER_COMMENT, parameters.getOrderComment());
        requestMap.put(Parameter.CARD_NUMBER, parameters.getCardNumber());
        requestMap.put(Parameter.CARD_HOLDER, parameters.getCardHolder());
        requestMap.put(Parameter.EXPIRE_MONTH, parameters.getExpireMonth());
        requestMap.put(Parameter.EXPIRE_YEAR, parameters.getExpireYear());
        requestMap.put(Parameter.LAST_NAME, parameters.getLastName());
        requestMap.put(Parameter.FIRST_NAME, parameters.getFirstName());
        requestMap.put(Parameter.EMAIL, parameters.getEmail());
        requestMap.put(Parameter.FORMAT, this.format().value());
        requestMap.put(Parameter.PAYMENT_MODE, "8");
        return requestMap;
    }

    @Override
    public SilentPayResponse toResult(Result response) {
        String responseStr;
        Objects.requireNonNull(response);
        try {
            responseStr = JiBXHelper.toString((Object)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SilentPayResponse silentPayResponse = new SilentPayResponse();
        silentPayResponse.setSuccess(false);
        silentPayResponse.setResponse(responseStr);
        String firstcode = response.getFirstcode();
        String secondcode = response.getSecondcode();
        if (!"0".equals(firstcode)) {
            if (Objects.isNull(firstcode) || Objects.isNull(secondcode)) {
                throw new IllegalStateException("first or second code is null");
            }
            String message = this.errorCodeMessageMap.get(firstcode + ":" + secondcode);
            String errorMessage = message != null ? L10nResourcesManager.getStr((String)message, (Object[])new Object[0]) : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b Assist: " + SilentPayResponse.FIRST_CODE_TABLE.get(firstcode) + " : " + SilentPayResponse.SECOND_CODE_TABLE.get(secondcode);
            silentPayResponse.setSuccess(false);
            silentPayResponse.setFirstCode(firstcode);
            silentPayResponse.setSecondCode(secondcode);
            silentPayResponse.setErrorMessage(errorMessage);
            return silentPayResponse;
        }
        Order order = (Order)response.getOrders().getOrderList().get(0);
        String responsecode = order.getResponsecode();
        if (!"AS000".equals(responsecode)) {
            String message = this.errorCodeMessageMap.get(responsecode);
            String errorMessage = message != null ? L10nResourcesManager.getStr((String)message, (Object[])new Object[0]) : "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b Assist: \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 " + responsecode;
            silentPayResponse.setSuccess(false);
            silentPayResponse.setResponseCode(responsecode);
            silentPayResponse.setErrorMessage(errorMessage);
            return silentPayResponse;
        }
        String approvalcode = order.getApprovalcode();
        if (Objects.isNull(approvalcode)) {
            String errorMessage = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e \u0441\u0442\u043e\u0440\u043e\u043d\u044b Assist: \u041a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442";
            silentPayResponse.setSuccess(false);
            silentPayResponse.setErrorMessage(errorMessage);
            return silentPayResponse;
        }
        String transactionCode = order.getBillnumber().split(Pattern.quote("."))[0];
        silentPayResponse.setSuccess(true);
        silentPayResponse.setApproveCode(approvalcode);
        silentPayResponse.setTransactionCode(transactionCode);
        return silentPayResponse;
    }

    private Map<CheckParameter, String> toCheckParameters(Result response, SilentPayRequest parameters, List<Message> messages) {
        EnumMap<CheckParameter, String> checkParameters = new EnumMap<CheckParameter, String>(CheckParameter.class);
        Order order = (Order)response.getOrders().getOrderList().get(0);
        try {
            String billNumber = order.getBillnumber().split(Pattern.quote("."))[0];
            String meanNumber = "****" + order.getMeannumber().split(Pattern.quote("****"))[1];
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(LocaleUtil.LOCALE_RU);
            decimalFormatSymbols.setDecimalSeparator('.');
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(LocaleUtil.LOCALE_RU);
            decimalFormat.setMinimumFractionDigits(2);
            decimalFormat.setMaximumFractionDigits(2);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            String amount = decimalFormat.format(new BigDecimal(order.getAmount()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            Date parseDate = simpleDateFormat.parse(order.getOrderdate());
            Date date = MiscUtil.addToDate((Date)parseDate, (int)3, (int)10);
            String orderDate = simpleDateFormat.format(date) + " (GMT +03:00)";
            String orderComment = parameters.getOrderComment();
            checkParameters.put(CheckParameter.BILL_NUMBER, billNumber);
            checkParameters.put(CheckParameter.ORDER_NUMBER, order.getOrdernumber().substring(0, order.getOrdernumber().indexOf(47)));
            checkParameters.put(CheckParameter.LAST_NAME, parameters.getLastName());
            checkParameters.put(CheckParameter.FIRST_NAME, parameters.getFirstName());
            checkParameters.put(CheckParameter.CURRENCY, order.getCurrency());
            checkParameters.put(CheckParameter.APPROVAL_CODE, order.getApprovalcode());
            checkParameters.put(CheckParameter.CUSTOMER_MESSAGE, order.getCustomermessage());
            checkParameters.put(CheckParameter.MEAN_TYPE_NAME, order.getMeantypename());
            checkParameters.put(CheckParameter.MEAN_NUMBER, meanNumber);
            checkParameters.put(CheckParameter.AMOUNT, amount);
            checkParameters.put(CheckParameter.ORDER_DATE, orderDate);
            checkParameters.put(CheckParameter.ORDER_COMMENT, orderComment);
            checkParameters.put(CheckParameter.ORGANIZATION_NAME, "CWT");
            checkParameters.put(CheckParameter.ORGANIZATION_URL, "account@carlsonwagonlit.ru");
            checkParameters.put(CheckParameter.RECEIPT_LINK, "");
        }
        catch (Exception e) {
            Message message = SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"error while prepare base parameters for check, exception={0}", (Object[])new Object[]{TextUtil.getExceptionStackTrace((Throwable)e)});
            messages.add(message);
        }
        return checkParameters;
    }

    /*
     * Exception decompiling
     */
    @Override
    public SilentPayResponse handle(SilentPayRequest parameters) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

