/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.ibus.check;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.IBusAssistCommonContextKeys;
import com.gridnine.xtrip.server.pg.assist.ibus.IBusAssistContextKeys;
import com.gridnine.xtrip.server.pg.assist.model.CheckParameter;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class AssistSetReceiptLinkIntoSlipProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer slipCtr = (EntityContainer)ctx.getObject((Enum)IBusAssistCommonContextKeys.SLIP);
        String receiptLink = (String)ctx.getMandatoryObject((Enum)IBusAssistContextKeys.SLIP_RECEIPT_LINK);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        PGConnector pgConnector = (PGConnector)ctx.getMandatoryObject((Enum)IBusPgContextKeys.PG_CONNECTOR);
        if (Objects.isNull(slipCtr)) {
            return;
        }
        NamedValue checkParametersNamedValue = NamedValueHelper.getNamedValueForName((String)AssistPGUtils.CHECK_PARAMETERS_KEY, (Collection)payment.getCustomParameters());
        String checkParametersStr = checkParametersNamedValue.getValue();
        Map<CheckParameter, String> checkParameters = AssistPGUtils.fromXmlString(checkParametersStr, () -> new EnumMap(CheckParameter.class));
        Locale preferredCheckLocale = AssistPGUtils.preferredCheckLocale(payment);
        checkParameters.put(CheckParameter.RECEIPT_LINK, L10nResourcesManager.getStr((String)"ASSIST_RECEIPT_LINK", (Locale)preferredCheckLocale, (Object[])new Object[]{receiptLink}));
        String checkStr = AssistPGUtils.toCheck(checkParameters, preferredCheckLocale, ctx);
        byte[] pdfContent = AssistPGUtils.toPdfContent(checkStr);
        Document slip = (Document)slipCtr.getEntity();
        slip.setContent(pdfContent);
        slip.setCheckSum(MiscUtil.getCheckSum((byte[])pdfContent));
        checkParametersNamedValue.setValue(AssistPGUtils.toXmlString(checkParameters));
        pgConnector.updateToQueue(payment);
    }
}

