/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.ibus.check;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.InvoiceLineComposer;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.model.CheckParameter;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AssistSlipUpdater
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Map slipCtrs = (Map)ctx.getObject((Enum)IBusPgConnectorContextKeys.CARD_PAYMENT_SLIPS);
        if (Objects.isNull(payment) || !payment.getPg().equals((Object)PgName.ASSIST)) {
            return;
        }
        if (Objects.isNull(bookingFileCtr)) {
            return;
        }
        if (CollectionUtil.isEmptyMap((Map)slipCtrs)) {
            return;
        }
        slipCtrs.forEach((key, value) -> AssistSlipUpdater.updateSlip(ctx, key, (BookingFile)bookingFileCtr.getEntity(), (EntityContainer<Document>)value));
    }

    private static List<BaseProduct> getSelectedProducts(BookingFile bookingFile, Payment payment) {
        String clientFopsXml = AssistPGUtils.getValue(payment, AssistPGUtils.CLIENT_FOPS_KEY);
        if (Objects.isNull(clientFopsXml)) {
            return BookingStreamHelper.baseProductStreamSafe((BookingFile)bookingFile).limit(1L).collect(Collectors.toList());
        }
        Map<BaseProduct, List<FopInfo>> restoreSelectedFops = AssistPGUtils.restore(bookingFile, payment);
        return new ArrayList<BaseProduct>(restoreSelectedFops.keySet());
    }

    public static void updateSlip(MessageContext ctx, Payment payment, BookingFile bookingFile, EntityContainer<Document> check) {
        byte[] pdfContent;
        Map<CheckParameter, String> checkParameters;
        List<BaseProduct> products = AssistSlipUpdater.getSelectedProducts(bookingFile, payment);
        if (CollectionUtil.isEmpty(products)) {
            return;
        }
        String checkParametersStr = AssistPGUtils.getValue(payment, AssistPGUtils.CHECK_PARAMETERS_KEY);
        try {
            checkParameters = AssistPGUtils.fromXmlString(checkParametersStr, () -> new EnumMap(CheckParameter.class));
        }
        catch (Exception e) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"Parsing check parameters failed!", (Object[])new Object[]{TextUtil.getExceptionStackTrace((Throwable)e)}));
            return;
        }
        if (checkParameters.size() != CheckParameter.values().length) {
            return;
        }
        Locale preferredCheckLocale = AssistPGUtils.preferredCheckLocale(payment);
        String comment = InvoiceLineComposer.getInstance().buildComment(bookingFile, preferredCheckLocale, products.get(0));
        checkParameters.put(CheckParameter.ORDER_COMMENT, comment);
        String checkStr = AssistPGUtils.toCheck(checkParameters, preferredCheckLocale, ctx);
        if (Objects.isNull(checkStr)) {
            return;
        }
        try {
            pdfContent = AssistPGUtils.toPdfContent(checkStr);
        }
        catch (Exception e) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"Building PDF content failed!", (Object[])new Object[]{TextUtil.getExceptionStackTrace((Throwable)e)}));
            return;
        }
        ((Document)check.getEntity()).setContent(pdfContent);
        EntityStorage.get().save(check, false);
    }
}

