/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.ibus.check;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.IBusAssistCommonContextKeys;
import com.gridnine.xtrip.server.pg.assist.model.CheckParameter;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class CreateAssistSlipProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        String checkParametersStr = NamedValueHelper.getValueForName((String)AssistPGUtils.CHECK_PARAMETERS_KEY, (Collection)payment.getCustomParameters());
        Map<CheckParameter, String> checkParameters = AssistPGUtils.fromXmlString(checkParametersStr, () -> new EnumMap(CheckParameter.class));
        if (checkParameters.size() != CheckParameter.values().length) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"not enough parameters, for generate check", (Object[])new Object[0]));
            return;
        }
        Locale preferredCheckLocale = AssistPGUtils.preferredCheckLocale(payment);
        String checkStr = AssistPGUtils.toCheck(checkParameters, preferredCheckLocale, ctx);
        if (Objects.isNull(checkStr)) {
            return;
        }
        byte[] pdfContent = AssistPGUtils.toPdfContent(checkStr);
        Document checkDocument = AssistPGUtils.toCheckDocument(pdfContent);
        checkDocument.setOwner(bookingFileCtr.toReference());
        checkDocument.getProperties().add(NamedValueHelper.namedValue((String)AssistPGUtils.PREFERRED_CHECK_LOCALE_KEY, (String)preferredCheckLocale.toLanguageTag()));
        ctx.putObject((Enum)IBusAssistCommonContextKeys.SLIP, (Object)EntityContainer.create((BaseEntity)checkDocument));
    }
}

