/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.ibus.check;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.IBusPgContextKeys;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.OrderResult;
import com.gridnine.xtrip.server.pg.assist.model.Format;
import com.gridnine.xtrip.server.pg.assist.model.MerchantSettings;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultRequest;
import com.gridnine.xtrip.server.pg.assist.model.Parameter;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import com.gridnine.xtrip.server.pg.rules.proxy.PGParametersProperties;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.stream.Collectors;

public class CreateOrderResultRequestProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PaymentCheckParameters checkParameters = (PaymentCheckParameters)ctx.getMandatoryObject((Enum)IBusPgContextKeys.INPUT_PAYMENT_PARAMETERS);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        MerchantSettings merchantSettings = this.merchantSettings(checkParameters, payment, (BookingFile)bookingFileCtr.getEntity());
        OrderResultRequest orderResultRequest = AssistPGUtils.newOrderResultRequest(merchantSettings, payment, Format.XML);
        HttpRequest httpRequest = this.httpRequest();
        httpRequest.setBody(this.body(orderResultRequest));
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private HttpRequest httpRequest() {
        OrderResult orderResult = new OrderResult();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(orderResult.buildUrl());
        httpRequest.setRequestMethod(RequestMethod.valueOf((String)orderResult.method()));
        httpRequest.getRequestProperties().put((Object)"Content-Type", (Object)"application/x-www-form-urlencoded;charset=UTF-8");
        return httpRequest;
    }

    private byte[] body(OrderResultRequest request) throws Exception {
        EnumMap<Parameter, String> parameters = new EnumMap<Parameter, String>(Parameter.class);
        MerchantSettings merchantSettings = request.getMerchantSettings();
        parameters.put(Parameter.MERCHANT_ID, merchantSettings.getId());
        parameters.put(Parameter.LOGIN, merchantSettings.getLogin());
        parameters.put(Parameter.PASSWORD, merchantSettings.getPassword());
        parameters.put(Parameter.ORDER_NUMBER, request.getOrderNumber());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(request.getPaymentDate());
        parameters.put(Parameter.START_YEAR, String.valueOf(calendar.get(1)));
        parameters.put(Parameter.START_MONTH, String.valueOf(calendar.get(2) + 1));
        parameters.put(Parameter.START_DAY, String.valueOf(calendar.get(5) - 1));
        parameters.put(Parameter.FORMAT, request.getFormat().value());
        Charset charset = Charset.forName("utf-8");
        return parameters.entrySet().stream().map(entry -> AssistPGUtils.toHttpRow((Parameter)((Object)((Object)entry.getKey())), (String)entry.getValue(), charset.name())).collect(Collectors.joining("&")).getBytes(charset);
    }

    private MerchantSettings merchantSettings(PaymentCheckParameters checkParameters, Payment payment, BookingFile bookingFile) throws Exception {
        SalesContext salesContext = checkParameters.getSalesContext();
        PGParametersProperties pgParametersProperties = PGParametersProperties.newInstance((PgName)payment.getPg(), (BookingFile)bookingFile, (PaymentType)payment.getPaymentType());
        PGParameters pgParameters = PGRulesHelper.newPgParameters((SalesContext)salesContext, (PGParametersProperties)pgParametersProperties);
        return MerchantSettings.newInstance(pgParameters);
    }
}

