/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.ibus.check;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgPaymentCheckStatus;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.model.CheckParameter;
import com.gridnine.xtrip.server.pg.assist.model.OrderResultResponse;
import com.gridnine.xtrip.server.pg.assist.model.orderResult.Operation;
import com.gridnine.xtrip.server.pg.assist.model.orderResult.Order;
import com.gridnine.xtrip.server.pg.helper.BookingFileHelper;
import com.gridnine.xtrip.server.pg.ibus.pgconnector.IBusPgConnectorContextKeys;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class HandleOrderResultResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        Payment payment = (Payment)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PAYMENT);
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List pgPaymentCheckMessages = (List)ctx.getMandatoryObject((Enum)IBusPgConnectorContextKeys.PG_PAYMENT_CHECK_MESSAGES);
        int responseCode = httpResponse.getResponseCode();
        if (responseCode != 200) {
            pgPaymentCheckMessages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"bad response code={0}", (Object[])new Object[]{responseCode}));
            throw Xeption.forDeveloper((String)"incorrect response code={0}", (Object[])new Object[]{responseCode});
        }
        OrderResultResponse response = OrderResultResponse.newInstance(httpResponse.getBody());
        if (!response.isSuccessResponse() || !response.isOrderPaid()) {
            pgPaymentCheckMessages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"not successful payment", (Object[])new Object[0]));
            ctx.putObject((Enum)IBusPgConnectorContextKeys.PG_PAYMENT_CHECK_STATUS, (Object)PgPaymentCheckStatus.ERROR);
            throw Xeption.forDeveloper((String)"not successful payment", (Object[])new Object[0]);
        }
        Map<CheckParameter, String> checkParameters = this.toCheckParameters(response, (BookingFile)bookingFileCtr.getEntity(), payment);
        payment.setDetails(response.cardTransactionDetails());
        payment.getCustomParameters().add(NamedValueHelper.namedValue((String)AssistPGUtils.CHECK_PARAMETERS_KEY, (String)AssistPGUtils.toXmlString(checkParameters)));
    }

    private Map<CheckParameter, String> toCheckParameters(OrderResultResponse response, BookingFile bookingFile, Payment payment) throws Exception {
        EnumMap<CheckParameter, String> checkParameters = new EnumMap<CheckParameter, String>(CheckParameter.class);
        Order order = response.getOrder();
        Operation operation = (Operation)order.getOperationList().get(0);
        String meanNumber = "****" + operation.getMeannumber().split(Pattern.quote("****"))[1];
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(LocaleUtil.LOCALE_RU);
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(LocaleUtil.LOCALE_RU);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        String amount = decimalFormat.format(new BigDecimal(operation.getAmount()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Date parseDate = simpleDateFormat.parse(order.getOrderdate());
        Date date = MiscUtil.addToDate((Date)parseDate, (int)3, (int)10);
        String orderDate = simpleDateFormat.format(date) + " (GMT +03:00)";
        String orderComment = NamedValueHelper.getValueForName((String)AssistPGUtils.ORDER_COMMENT_KEY, (Collection)payment.getCustomParameters());
        Passport passport = BookingFileHelper.traveller((BookingFile)bookingFile).getPassport();
        String lastName = StringUtils.capitalize((String)passport.getLastName());
        String firstName = StringUtils.capitalize((String)passport.getFirstName());
        checkParameters.put(CheckParameter.BILL_NUMBER, order.getBillnumber());
        checkParameters.put(CheckParameter.MEAN_NUMBER, meanNumber);
        checkParameters.put(CheckParameter.AMOUNT, amount);
        checkParameters.put(CheckParameter.ORGANIZATION_NAME, "CWT");
        checkParameters.put(CheckParameter.ORGANIZATION_URL, "account@carlsonwagonlit.ru");
        checkParameters.put(CheckParameter.CURRENCY, operation.getCurrency());
        checkParameters.put(CheckParameter.APPROVAL_CODE, operation.getApprovalcode());
        checkParameters.put(CheckParameter.CUSTOMER_MESSAGE, operation.getCustomermessage());
        checkParameters.put(CheckParameter.MEAN_TYPE_NAME, operation.getMeantypename());
        checkParameters.put(CheckParameter.ORDER_NUMBER, order.getOrdernumber().split(Pattern.quote("/"))[0]);
        checkParameters.put(CheckParameter.ORDER_DATE, orderDate);
        checkParameters.put(CheckParameter.ORDER_COMMENT, orderComment);
        checkParameters.put(CheckParameter.LAST_NAME, lastName);
        checkParameters.put(CheckParameter.FIRST_NAME, firstName);
        checkParameters.put(CheckParameter.RECEIPT_LINK, "");
        return checkParameters;
    }
}

