/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.ibus.split;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.pg.model.FopInfo;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pg.assist.AssistPGUtils;
import com.gridnine.xtrip.server.pg.assist.ibus.IBusAssistContextKeys;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AssistPrepareSplitProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Fop fop = (Fop)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.FOP);
        Map<BaseProduct, List<FopInfo>> unpaidFops = AssistPGUtils.unpaidFopsWithApplyRules((EntityContainer<BookingFile>)bookingFileCtr, fop.getType());
        Map<BaseProduct, List> splitFops = AssistPGUtils.valueTransformation(unpaidFops, Collectors.partitioningBy(this.splitFop())).entrySet().stream().map(entry -> new MiscUtil.Pair(entry.getKey(), ((Map)entry.getValue()).get(Boolean.TRUE))).filter(pair -> CollectionUtil.isNotEmpty((Collection)((Collection)pair.getSecond()))).collect(Collectors.toMap(MiscUtil.Pair::getFirst, MiscUtil.Pair::getSecond));
        if (unpaidFops.size() != splitFops.size()) {
            throw Xeption.forEndUser((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0431\u043e\u0440\u043e\u0432, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0441\u043b\u0443\u0436\u0431\u0443 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0438", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusAssistContextKeys.CLIENT_FOPS, splitFops);
    }

    private Predicate<? super FopInfo> splitFop() {
        return fopInfo -> FopType.SERVICE == fopInfo.getFopType();
    }
}

