/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.model;

import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.pg.assist.model.Parameter;
import java.util.Arrays;
import java.util.Objects;

public enum AssistPaymentType {
    CARD_PAYMENT(Parameter.CARD_PAYMENT, PaymentType.CREDIT_CARD_ASSIST),
    YM_PAYMENT(Parameter.YM_PAYMENT, null),
    WM_PAYMENT(Parameter.WM_PAYMENT, null),
    QIWI_PAYMENT(Parameter.QIWI_PAYMENT, null),
    QIWI_MTS_PAYMENT(Parameter.QIWI_MTS_PAYMENT, null),
    QIWI_MEGAFON_PAYMENT(Parameter.QIWI_MEGAFON_PAYMENT, null),
    QIWI_BEELINE_PAYMENT(Parameter.QIWI_BEELINE_PAYMENT, null),
    QIWI_TELE2_PAYMENT(Parameter.QIWI_TELE2_PAYMENT, null);

    private final Parameter parameter;
    private final PaymentType systemPaymentType;

    private AssistPaymentType(Parameter parameter, PaymentType systemPaymentType) {
        this.parameter = Objects.requireNonNull(parameter, "no Parameter");
        this.systemPaymentType = systemPaymentType;
    }

    public Parameter parameter() {
        return this.parameter;
    }

    public PaymentType systemPaymentType() {
        return this.systemPaymentType;
    }

    public static AssistPaymentType valueOf(PaymentType systemPaymentType) {
        if (Objects.isNull(systemPaymentType)) {
            return null;
        }
        return Arrays.stream(AssistPaymentType.values()).filter(assistPaymentType -> systemPaymentType == assistPaymentType.systemPaymentType).findFirst().orElse(null);
    }
}

