/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.model;

import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;

public enum MeanType {
    VISA("VISA", 1, CardVendor.VISA),
    MC("MC", 2, CardVendor.MASTERCARD),
    DCL("DCL", 3, CardVendor.DINERS_CLUB),
    JCB("JCB", 4, CardVendor.JCB),
    AMEX("AMEX", 5, CardVendor.AMEX),
    MIR("MIR", 6, CardVendor.AMEX),
    DISCOVER("Discover", 10, null),
    POINTS("Points", 12, null),
    WEB_MONEY("WebMoney", 30, null),
    YANDEX_MONEY("YandexMoney", 32, null),
    QIWI("QIWI", 36, null),
    BANK_CLIENT("BankClient", 37, null),
    QIWI_BEELINE("QIWIBeeline", 39, null),
    QIWI_MTS("QIWIMts", 40, null),
    QIWI_MEGAFON("QIWIMegafon", 41, null),
    QIWI_TELE2("QIWITele2", 42, null),
    APPLE_PAY("ApplePay", 60, null),
    SAMSUNG_PAY("SamsungPay", 61, null),
    ANDROID_PAY("AndroidPay", 62, null);

    private final String origin;
    private final int id;
    private final CardVendor cardVendor;

    private MeanType(String origin, int id, CardVendor cardVendor) {
        this.origin = origin;
        this.id = id;
        this.cardVendor = cardVendor;
    }

    public static MeanType byOrigin(String origin) {
        if (origin == null) {
            return null;
        }
        return Arrays.stream(MeanType.values()).filter(meanType -> TextUtil.equals((String)meanType.origin, (String)origin, (boolean)false)).findFirst().orElse(null);
    }

    public static MeanType byId(int id) {
        return Arrays.stream(MeanType.values()).filter(meanType -> meanType.id == id).findFirst().orElse(null);
    }

    public static MeanType byCardVendor(CardVendor cardVendor) {
        if (cardVendor == null) {
            return null;
        }
        return Arrays.stream(MeanType.values()).filter(meanType -> meanType.cardVendor == cardVendor).findFirst().orElse(null);
    }

    public String origin() {
        return this.origin;
    }

    public int id() {
        return this.id;
    }

    public CardVendor cardVendor() {
        return this.cardVendor;
    }
}

