/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.model;

import com.gridnine.xtrip.common.pg.model.PGParameters;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public final class MerchantSettings {
    private static final String PG_ACCOUNT_SEPARATOR = Pattern.quote(";");
    private final String id;
    private final String login;
    private final String password;

    public MerchantSettings(String id, String login, String password) {
        this.id = Objects.requireNonNull(id);
        this.login = Objects.requireNonNull(login);
        this.password = Objects.requireNonNull(password);
    }

    public static MerchantSettings newInstance(PGParameters pgParameters) {
        String[] pgAccountValues = Optional.ofNullable(pgParameters).map(PGParameters::getPgAccount).map(pgAccountStr -> pgAccountStr.split(PG_ACCOUNT_SEPARATOR)).get();
        return new MerchantSettings(pgAccountValues[0], pgAccountValues[1], pgParameters.getPgPassword());
    }

    public String getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }
}

