/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.assist.model;

import com.gridnine.xtrip.common.model.system.CardTransactionDetails;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.jibx.JiBXHelper;
import com.gridnine.xtrip.server.pg.assist.model.FirstCode;
import com.gridnine.xtrip.server.pg.assist.model.MeanType;
import com.gridnine.xtrip.server.pg.assist.model.OperationState;
import com.gridnine.xtrip.server.pg.assist.model.OrderState;
import com.gridnine.xtrip.server.pg.assist.model.orderResult.Operation;
import com.gridnine.xtrip.server.pg.assist.model.orderResult.Order;
import com.gridnine.xtrip.server.pg.assist.model.orderResult.Result;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class OrderResultResponse {
    private final Result result;
    private final Order order;

    private OrderResultResponse(Result result) {
        this.result = result;
        List orderList = result.getOrderList();
        this.order = Objects.isNull(orderList) ? null : (Order)orderList.stream().filter(Objects::nonNull).findAny().orElse(null);
    }

    public static OrderResultResponse newInstance(byte[] bytes) throws Exception {
        return new OrderResultResponse((Result)JiBXHelper.read(Result.class, (byte[])bytes));
    }

    public static OrderResultResponse newInstance(InputStream inputStream) throws Exception {
        return new OrderResultResponse((Result)JiBXHelper.read(Result.class, (InputStream)inputStream));
    }

    public Result getResult() {
        return this.result;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isSuccessResponse() {
        return FirstCode.SUCCESS == FirstCode.byOrigin(this.result.getFirstcode());
    }

    public boolean isOrderPaid() {
        return OrderState.APPROVED == OrderState.byOrigin(this.order.getOrderstate());
    }

    public String approvalCode() {
        return this.getValue(Operation::getApprovalcode);
    }

    public CardTransactionDetails cardTransactionDetails() {
        CardTransactionDetails cardTransactionDetails = new CardTransactionDetails();
        cardTransactionDetails.setTransactionCode(this.order.getBillnumber());
        cardTransactionDetails.setNameOnCard(this.getValue(Operation::getCardholder));
        cardTransactionDetails.setNumber(this.getValue(Operation::getMeannumber));
        cardTransactionDetails.setSecurityCode(this.approvalCode());
        Optional<MeanType> meanType = Optional.ofNullable(MeanType.byOrigin(this.getValue(Operation::getMeantypename)));
        cardTransactionDetails.setVendor((CardVendor)meanType.map(MeanType::cardVendor).orElse(null));
        return cardTransactionDetails;
    }

    public BigDecimal amount(Function<Operation, BigDecimal> amountExtractor) {
        Objects.requireNonNull(amountExtractor);
        return this.order.getOperationList().stream().filter(Objects::nonNull).filter(operation -> OperationState.SUCCESS == OperationState.byOrigin(operation.getOperationstate())).map(amountExtractor).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private String getValue(Function<Operation, String> mapper) {
        Objects.requireNonNull(mapper, "empty mapper");
        return this.order.getOperationList().stream().filter(Objects::nonNull).map(mapper).filter(TextUtil::nonBlank).findAny().orElse(null);
    }
}

