/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.pg.MidofficePGLockManager;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGLockManager;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.PgSysLogItem;
import com.gridnine.xtrip.server.pg.bankofgeorgia.BankOfGeorgiaPGConnector;
import com.gridnine.xtrip.server.pg.bankofgeorgia.BankRemoteRequest;
import com.gridnine.xtrip.server.pg.bankofgeorgia.DefaultOrderPriceProvider;
import com.gridnine.xtrip.server.pg.bankofgeorgia.MerchantSettings;
import com.gridnine.xtrip.server.pg.bankofgeorgia.MerchantSettingsProvider;
import com.gridnine.xtrip.server.pg.bankofgeorgia.OrderPriceProvider;
import com.gridnine.xtrip.server.pg.bankofgeorgia.ResultCode;
import com.gridnine.xtrip.server.pg.bankofgeorgia.RulesMerchantSettingsProvider;
import com.gridnine.xtrip.server.pg.bankofgeorgia.client.ResponseType;
import com.gridnine.xtrip.server.pg.bankofgeorgia.client.ResultType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicTemplate<R extends ResponseType> {
    protected final BankRemoteRequest bankRequest;
    protected final UsernamePasswordCredentials credentials;
    protected final PaymentQueueManager paymentQueueManager;
    private final Logger log = LoggerFactory.getLogger(AbstractLogicTemplate.class);
    protected OrderPriceProvider orderPriceProvider = new DefaultOrderPriceProvider();
    protected Payment payment;
    protected EntityContainer<BookingFile> bookingFile;
    private PGLockManager lockManager = new MidofficePGLockManager();
    private MerchantSettingsProvider merchantSettingsProvider = new RulesMerchantSettingsProvider();
    private MerchantSettings merchantSettings;
    private PgSysLogItem logItem = this.createLogItem();

    public AbstractLogicTemplate(BankRemoteRequest bankRequest, UsernamePasswordCredentials credentials, PaymentQueueManager paymentQueueManager) {
        this.bankRequest = bankRequest;
        this.credentials = credentials;
        this.paymentQueueManager = paymentQueueManager;
    }

    public void setLockManager(PGLockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setOrderPriceProvider(OrderPriceProvider orderPriceProvider) {
        this.orderPriceProvider = orderPriceProvider;
    }

    public void setMerchantSettingsProvider(MerchantSettingsProvider merchantSettingsProvider) {
        this.merchantSettingsProvider = merchantSettingsProvider;
    }

    public R execute() {
        try {
            this.logAllParameters();
            if (!this.areAllFieldsValid()) {
                throw new PGException("not valid request");
            }
            R r = this.doUnderOrderIdLock();
            return r;
        }
        catch (Exception e) {
            R r = this.handleProcessException(e);
            return r;
        }
        finally {
            this.saveLogItem();
        }
    }

    public PgSysLogItem getLogItem() {
        return this.logItem;
    }

    private void logAllParameters() {
        this.logItem.addMessage("Parameters");
        this.bankRequest.getParams().entrySet().forEach(entry -> this.logItem.addMessage((String)entry.getKey() + ": " + (String)entry.getValue()));
    }

    private R doUnderOrderIdLock() throws Exception {
        return (R)((ResponseType)this.lockManager.underLock(PgName.BANK_OF_GEORGIA, BankOfGeorgiaPGConnector.class, this.bankRequest.getOrderId(), () -> {
            this.getPaymentFromQueue();
            this.loadMerchantSettings();
            this.checkCredentials();
            this.bookingFile = this.resolveEntity(this.payment);
            return this.doLogicUnderLock();
        }, TimeUnit.MINUTES, 5L));
    }

    private R doLogicUnderLock() throws InterruptedException, TimeoutException {
        return (R)((ResponseType)this.lockManager.underLock(this.bookingFile.toReference(), x -> this.doLogic()));
    }

    protected abstract R doLogic();

    private void loadMerchantSettings() {
        this.merchantSettings = this.merchantSettingsProvider.getMerchantSettings(this.payment);
    }

    private void checkCredentials() {
        if (this.credentials == null || !this.credentials.getUserName().equals(this.merchantSettings.getHttpAuthLogin()) || !this.credentials.getPassword().equals(this.merchantSettings.getHttpAuthPassword())) {
            throw new PGException("unauthorized");
        }
    }

    protected abstract PgSysLogItem createLogItem();

    protected void getPaymentFromQueue() throws Exception {
        this.payment = this.paymentQueueManager.getFromQueue(this.bankRequest.getOrderId());
        if (this.payment == null) {
            throw new PGException("order not found");
        }
    }

    protected ResultType createResult(ResultCode status, String description) {
        ResultType resultType = new ResultType();
        resultType.setCode(status.getCode());
        resultType.setDesc(description);
        return resultType;
    }

    private void saveLogItem() {
        if (this.bookingFile != null) {
            SysLogHelper.audit((EntityReference)this.bookingFile.toReference(), (String)"pg-bankofgeorgia", (Message[])new Message[]{this.logItem.toMessage()});
        }
    }

    protected R createResponse(ResultType resultType) {
        R response = this.createResponseType();
        response.setResult(resultType);
        return response;
    }

    protected abstract R createResponseType();

    private R handleProcessException(Exception e) {
        this.log.error("check error", (Throwable)e);
        this.logItem.addError(e.toString(), new Object[0]);
        return this.createResponse(this.createResult(ResultCode.FAIL, e instanceof PGException ? e.getMessage() : "server error"));
    }

    private EntityContainer<BookingFile> resolveEntity(Payment payment) {
        return EntityStorage.get().resolve(payment.getEntity());
    }

    protected R createSuccessfulResponse() {
        return this.createResponse(this.createResult(ResultCode.SUCCESS, "OK"));
    }

    protected abstract boolean areAllFieldsValid();

    protected BigDecimal getOrderPrice() {
        return this.orderPriceProvider.get(this.bookingFile, ContractType.CLIENT).multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP);
    }
}

