/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.bof.midoffice.trace.TraceItem;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.bankofgeorgia.AbstractLogicTemplate;
import com.gridnine.xtrip.server.pg.bankofgeorgia.BankRemoteRequest;
import com.gridnine.xtrip.server.pg.bankofgeorgia.CredentialsExtractor;
import com.gridnine.xtrip.server.pg.bankofgeorgia.ResponseMarshaller;
import com.gridnine.xtrip.server.pg.trace.ExceptionItem;
import com.gridnine.xtrip.server.pg.trace.HttpRequestItem;
import com.gridnine.xtrip.server.pg.trace.ServletResponseItem;
import com.gridnine.xtrip.server.pg.trace.StepItem;
import com.gridnine.xtrip.server.pg.trace.TraceLog;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.auth.UsernamePasswordCredentials;

public abstract class AbstractTemplateServlet
extends PGServlet {
    private static final long serialVersionUID = 9083032265046450896L;

    protected abstract AbstractLogicTemplate createServletLogic(BankRemoteRequest var1, UsernamePasswordCredentials var2, PaymentQueueManager var3, TraceLog var4);

    protected abstract String getOperationName();

    protected PgName getId() {
        return PgName.BANK_OF_GEORGIA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TraceLog traceLog = new TraceLog(this.getOperationName());
        try {
            traceLog.addStep((StepItem)new HttpRequestItem(request));
            BankRemoteRequest bankRequest = new BankRemoteRequest(request.getParameterMap());
            Optional<UsernamePasswordCredentials> credentials = new CredentialsExtractor().get(request);
            AbstractLogicTemplate servletLogic = this.createServletLogic(bankRequest, credentials.orElseGet(() -> null), this.getConnector().getQueueManager(), traceLog);
            LogicalStorage.get().authorizeAsSystem();
            PGServletResponse pgResponse = new PGServletResponse(response);
            pgResponse.setResponseText(ResponseMarshaller.toXml(servletLogic.execute()));
            traceLog.addStep((StepItem)new ServletResponseItem(pgResponse));
            pgResponse.send();
        }
        catch (Exception e) {
            try {
                this.log("error", e);
                traceLog.addStep((StepItem)new ExceptionItem((Throwable)e));
            }
            catch (Throwable throwable) {
                this.getTracer().trace(new TraceItem[]{traceLog.toTraceItem()});
                throw throwable;
            }
            this.getTracer().trace(new TraceItem[]{traceLog.toTraceItem()});
        }
        this.getTracer().trace(new TraceItem[]{traceLog.toTraceItem()});
    }
}

