/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGHelper;

public class BankOfGeorgiaPGConnector
extends PGConnector {
    private boolean enabled;
    private Tracer tracer;
    private boolean disposed;

    public PgName getId() {
        return PgName.BANK_OF_GEORGIA;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    public void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.tracer = PGHelper.createTracer((PgName)this.getId());
        this.log.debug("configured");
    }

    protected Long getQueuePeriod() {
        return null;
    }

    public ContractType getContractType() {
        return ContractType.CLIENT;
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_BANK_OF_GEORGIA);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        this.checkDisposedState();
        return this.defaultInitiateIBusPayment(parameters);
    }

    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        throw new UnsupportedOperationException();
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    private void checkDisposedState() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
    }
}

