/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BankRemoteRequest {
    private Map<String, String> params = new HashMap<String, String>();

    public BankRemoteRequest(Map<String, String[]> servletParams) {
        this.convertParams(servletParams);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getMerchantId() {
        return this.params.get("merch_id");
    }

    public String getTransactionId() {
        return this.params.get("trx_id");
    }

    public String getOrderId() {
        return this.params.get("o.order_id");
    }

    public String getMerchantTransaction() {
        return this.params.get("merchant_trx");
    }

    public String getResultCode() {
        return this.params.get("result_code");
    }

    public Optional<BigDecimal> getAmount() {
        String amount = this.params.get("amount");
        if (amount == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(amount));
    }

    public String getAccountId() {
        return this.params.get("account_id");
    }

    public boolean isFullyAuthenticated() {
        return "Y".equals(this.params.get("isFullyAuthenticated"));
    }

    public String getMaskedPan() {
        return this.params.get("p.maskedPan");
    }

    public String getCardHolder() {
        return this.params.get("p.cardholder");
    }

    public String getTransactionDate() {
        return this.params.get("ts");
    }

    public String getSignature() {
        return this.params.get("signature");
    }

    private void convertParams(Map<String, String[]> servletParams) {
        servletParams.entrySet().stream().forEach(entry -> this.params.put((String)entry.getKey(), ((String[])entry.getValue())[0]));
    }
}

