/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PaymentQueueManager;
import com.gridnine.xtrip.server.pg.PgSysLogItem;
import com.gridnine.xtrip.server.pg.bankofgeorgia.AbstractLogicTemplate;
import com.gridnine.xtrip.server.pg.bankofgeorgia.BankRemoteRequest;
import com.gridnine.xtrip.server.pg.bankofgeorgia.client.AccountAmountType;
import com.gridnine.xtrip.server.pg.bankofgeorgia.client.PaymentAvailResponse;
import com.gridnine.xtrip.server.pg.bankofgeorgia.client.PurchaseType;
import org.apache.http.auth.UsernamePasswordCredentials;

public class CheckAvailableLogic
extends AbstractLogicTemplate<PaymentAvailResponse> {
    public final String LARI_CURRENCY_CODE = "981";

    public CheckAvailableLogic(BankRemoteRequest bankRequest, UsernamePasswordCredentials credentials, PaymentQueueManager paymentQueueManager) {
        super(bankRequest, credentials, paymentQueueManager);
    }

    @Override
    protected PaymentAvailResponse doLogic() {
        PaymentAvailResponse response = (PaymentAvailResponse)this.createSuccessfulResponse();
        response.setPurchase(new PurchaseType());
        response.getPurchase().setShortDesc(this.getDescription());
        response.getPurchase().setLongDesc(this.getDescription());
        response.setMerchantTrx(this.payment.getUid());
        this.setAccountAmount(response);
        return response;
    }

    @Override
    protected PgSysLogItem createLogItem() {
        return new PgSysLogItem("pg-bankofgeorgia", "checkPayment");
    }

    @Override
    protected PaymentAvailResponse createResponseType() {
        return new PaymentAvailResponse();
    }

    private String getDescription() {
        Reservation reservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)this.bookingFile.getEntity()), (boolean)true);
        return "Payment of " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
    }

    private void setAccountAmount(PaymentAvailResponse response) {
        response.getPurchase().setAccountAmount(new AccountAmountType());
        response.getPurchase().getAccountAmount().setAmount(this.getOrderPrice().toString());
        response.getPurchase().getAccountAmount().setCurrency("981");
        response.getPurchase().getAccountAmount().setExponent("2");
    }

    @Override
    protected boolean areAllFieldsValid() {
        return !TextUtil.isBlank((String)this.bankRequest.getMerchantId()) && !TextUtil.isBlank((String)this.bankRequest.getTransactionId()) && !TextUtil.isBlank((String)this.bankRequest.getOrderId());
    }
}

