/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.xtrip.common.util.TextUtil;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.auth.UsernamePasswordCredentials;

public class CredentialsExtractor {
    public Optional<UsernamePasswordCredentials> get(HttpServletRequest httpRequest) {
        String authorization = httpRequest.getHeader("Authorization");
        if (TextUtil.isBlank((String)authorization) || !authorization.startsWith("Basic")) {
            return Optional.empty();
        }
        String base64Credentials = authorization.substring("Basic".length()).trim();
        String credentials = new String(Base64.getDecoder().decode(base64Credentials), Charset.forName("UTF-8"));
        String[] values = credentials.split(":", 2);
        return Optional.of(new UsernamePasswordCredentials(values[0], values[1]));
    }
}

