/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.pg.bankofgeorgia.BankOfGeorgiaSettings;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PgSysLogItem;
import com.gridnine.xtrip.server.pg.bankofgeorgia.MerchantSettings;
import com.gridnine.xtrip.server.pg.bankofgeorgia.MerchantSettingsConverter;

public class InitiatePayment {
    private final PaymentInitiationParameters params;
    private final MerchantSettings merchantSettings;
    private final EntityContainer<BookingFile> bookingFile;
    private final BankOfGeorgiaSettings settings;
    private PaymentInitiationResult result = new PaymentInitiationResult();
    private PgSysLogItem logItem = new PgSysLogItem("bankofgeorgia", "\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");

    public InitiatePayment(PaymentInitiationParameters params, PaymentInitiationResult result, PGParameters pgParameters, EntityContainer<BookingFile> bookingFile, BankOfGeorgiaSettings settings) {
        this.params = params;
        this.result = result;
        this.merchantSettings = new MerchantSettingsConverter().getMerchantSettings(pgParameters);
        this.bookingFile = bookingFile;
        this.settings = settings;
    }

    public PgSysLogItem getLogItem() {
        return this.logItem;
    }

    public void process() {
        try {
            this.validateRequiredFields();
            this.result.getRedirectForm().setUrl(this.settings.getServiceUrl());
            this.result.getRedirectForm().setMethod("GET");
            this.addMerchantId();
            this.addOrderId();
            this.result.getRedirectForm().getParameters().add(this.createNamedValue("lang", "ru"));
            this.addBackUrls();
            this.logRedirectForm();
        }
        catch (Exception e) {
            this.logItem.addError(e.toString(), new Object[0]);
            throw e;
        }
    }

    private void validateRequiredFields() {
        if (TextUtil.isBlank((String)this.settings.getServiceUrl())) {
            throw new PGException("empty service url");
        }
        if (!MerchantSettingsConverter.isValid(this.merchantSettings)) {
            throw new PGException("invalid merchant settings");
        }
        if (TextUtil.isBlank((String)this.params.getReturnUrl())) {
            throw new PGException("empty returnUrl");
        }
    }

    private void logRedirectForm() {
        this.logItem.addMessage("serviceUrl [%s]", new Object[]{this.result.getRedirectForm().getUrl()});
        this.result.getRedirectForm().getParameters().stream().forEach(namedValue -> this.logItem.addMessage("formParameter [%s=%s]", new Object[]{namedValue.getName(), namedValue.getValue()}));
    }

    private void addMerchantId() {
        this.result.getRedirectForm().getParameters().add(this.createNamedValue("merch_id", this.merchantSettings.getMerchantId()));
    }

    private void addOrderId() {
        String orderNumber = ((BookingFile)this.bookingFile.getEntity()).getNumber();
        this.result.getRedirectForm().getParameters().add(this.createNamedValue("o.order_id", orderNumber));
        this.result.getPayment().setPaymentId(orderNumber);
    }

    private void addBackUrls() {
        this.result.getRedirectForm().getParameters().add(this.createNamedValue("back_url_s", this.params.getReturnUrl() + "&status=1"));
        this.result.getRedirectForm().getParameters().add(this.createNamedValue("back_url_f", this.params.getReturnUrl() + "&status=0"));
    }

    private NamedValue createNamedValue(String name, String value) {
        NamedValue result = new NamedValue();
        result.setName(name);
        result.setValue(value);
        return result;
    }
}

