/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.bankofgeorgia.MerchantSettings;

public class MerchantSettingsConverter {
    public static boolean isValid(MerchantSettings settings) {
        return !TextUtil.isBlank((String)settings.getMerchantId()) && !TextUtil.isBlank((String)settings.getHttpAuthLogin()) && !TextUtil.isBlank((String)settings.getHttpAuthPassword());
    }

    public MerchantSettings getMerchantSettings(PGParameters pgParameters) {
        try {
            return this.createSettings(pgParameters);
        }
        catch (Exception e) {
            throw new PGException("getMerchantSettings error", (Throwable)e);
        }
    }

    private MerchantSettings createSettings(PGParameters pgParameters) {
        MerchantSettings settings = new MerchantSettings();
        if (pgParameters.getPgAccount() != null) {
            String[] values = pgParameters.getPgAccount().split(";");
            settings.setMerchantId(values[0]);
            if (values.length > 1) {
                settings.setHttpAuthLogin(values[1]);
            }
        }
        settings.setHttpAuthPassword(pgParameters.getPgPassword());
        return settings;
    }
}

