/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.bankofgeorgia;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PgSysLogItem;
import com.gridnine.xtrip.server.pg.bankofgeorgia.AbstractLogicTemplate;
import com.gridnine.xtrip.server.pg.bankofgeorgia.BankRemoteRequest;
import com.gridnine.xtrip.server.pg.bankofgeorgia.CardTransactionDetailsBuilder;
import com.gridnine.xtrip.server.pg.bankofgeorgia.PgConnectorMethods;
import com.gridnine.xtrip.server.pg.bankofgeorgia.client.RegisterPaymentResponseType;
import com.gridnine.xtrip.server.pg.trace.SimpleItem;
import com.gridnine.xtrip.server.pg.trace.StepItem;
import com.gridnine.xtrip.server.pg.trace.TraceLog;
import com.gridnine.xtrip.server.pg.trace.XSeriazibleItem;
import java.math.BigDecimal;
import java.util.Collections;
import org.apache.http.auth.UsernamePasswordCredentials;

public class RegisterPaymentLogic
extends AbstractLogicTemplate<RegisterPaymentResponseType> {
    private final PgConnectorMethods connectorMethods;
    private final TraceLog traceLog;

    public RegisterPaymentLogic(BankRemoteRequest bankRequest, UsernamePasswordCredentials credentials, PgConnectorMethods connectorMethods, TraceLog traceLog) {
        super(bankRequest, credentials, connectorMethods.getPaymentQueueManager());
        this.connectorMethods = connectorMethods;
        this.traceLog = traceLog;
    }

    @Override
    protected void getPaymentFromQueue() throws Exception {
        super.getPaymentFromQueue();
        this.traceLog.addStep((StepItem)new XSeriazibleItem((XSSerializable)this.payment));
    }

    @Override
    protected RegisterPaymentResponseType createResponseType() {
        return new RegisterPaymentResponseType();
    }

    private RegisterPaymentResponseType handleSuccessfulPayment() {
        this.payment.setDetails(new CardTransactionDetailsBuilder(this.bankRequest).create());
        try {
            this.connectorMethods.paymentSucceeded(this.payment, Collections.emptyList());
        }
        catch (Exception e) {
            throw new PGException("paymentSucceeded error", (Throwable)e);
        }
        return (RegisterPaymentResponseType)this.createSuccessfulResponse();
    }

    private RegisterPaymentResponseType handleNotSuccessfulPayment() {
        this.traceLog.addStep((StepItem)new SimpleItem("Order not paid"));
        return (RegisterPaymentResponseType)this.createSuccessfulResponse();
    }

    private boolean isSuccessfulPayment() {
        return "1".equals(this.bankRequest.getResultCode());
    }

    private void checkPaymentUid() {
        if (!this.payment.getUid().equals(this.bankRequest.getMerchantTransaction())) {
            this.traceLog.addStep((StepItem)new SimpleItem("incorrect merchant_trx"));
            throw new PGException("invalid merchant_trx");
        }
    }

    private void checkPaidSum() {
        BigDecimal paidPrice;
        boolean fullyPayed;
        BigDecimal orderPrice = this.getOrderPrice();
        boolean bl = fullyPayed = orderPrice.compareTo(paidPrice = this.bankRequest.getAmount().get()) == 0;
        if (!fullyPayed) {
            this.traceLog.addStep((StepItem)new SimpleItem(String.format("not fully paid, orderPrice " + orderPrice + ", paid " + paidPrice, new Object[0])));
            throw new PGException("not fully paid");
        }
    }

    @Override
    protected RegisterPaymentResponseType doLogic() {
        if (!this.isSuccessfulPayment()) {
            return this.handleNotSuccessfulPayment();
        }
        this.checkPaymentUid();
        this.checkPaidSum();
        return this.handleSuccessfulPayment();
    }

    @Override
    protected PgSysLogItem createLogItem() {
        return new PgSysLogItem("bankofgeorgia", "registerPayment");
    }

    @Override
    protected boolean areAllFieldsValid() {
        return !TextUtil.isBlank((String)this.bankRequest.getMerchantId()) && !TextUtil.isBlank((String)this.bankRequest.getTransactionId()) && !TextUtil.isBlank((String)this.bankRequest.getOrderId()) && !TextUtil.isBlank((String)this.bankRequest.getResultCode()) && this.bankRequest.getAmount().isPresent() && !TextUtil.isBlank((String)this.bankRequest.getMerchantTransaction());
    }
}

