/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.brs;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.BaseTransactionDetails;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.InvoiceTransactionDetails;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.brs.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BRSPGServlet
extends PGServlet {
    private static final long serialVersionUID = 5107482932503807081L;
    private static final Logger log = LoggerFactory.getLogger(BRSPGServlet.class);
    private static Map<String, Element> rollDataResponses = new HashMap<String, Element>();
    private static NumberFormat sumF = new DecimalFormat("#0.00");

    private static SimpleDateFormat createDf() {
        return new SimpleDateFormat("yyyyMMddhhmmss");
    }

    protected PgName getId() {
        return PgName.BRS;
    }

    private static EntityContainer<BookingFile> findBookingFile(String bookingNumber, boolean toBePayed) throws Exception {
        List result = PaymentHelper.searchBookingFile((String)bookingNumber, (boolean)toBePayed);
        if (result.size() != 1) {
            return null;
        }
        return EntityStorage.get().resolve(((BookingFileIndex)result.get(0)).getSource());
    }

    private List<BillingTransactionIndex> getTransactions(EntityContainer<BookingFile> bfCtr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.referencedEntity.name(), (Object)bfCtr.toReference()));
        SearchResult searchResult = LogicalStorage.get().getEntityStorage().search(BillingTransactionIndex.class, query);
        return searchResult.getData();
    }

    private List<BillingTransactionIndex> getTransactions(Date dateFrom, Date dateTo) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.paymentType.name(), (Object)PaymentType.BRS));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)dateFrom, (Object)dateTo));
        SearchResult searchResult = LogicalStorage.get().getEntityStorage().search(BillingTransactionIndex.class, query);
        return searchResult.getData();
    }

    private BillingTransactionIndex getTransaction(String code) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCode.name(), (Object)code));
        SearchResult searchResult = LogicalStorage.get().getEntityStorage().search(BillingTransactionIndex.class, query);
        if (searchResult.getTotalCount() == 0) {
            return null;
        }
        return (BillingTransactionIndex)searchResult.getData().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ValueHolder paymentHolder;
        LinkedList pgLog;
        LinkedList messages;
        block41: {
            log.debug("service() BEGIN");
            PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
            Date startDate = new Date();
            Map request = PGHelper.convertRequestParametersMap((Map)req.getParameterMap());
            Element response = null;
            messages = new LinkedList();
            pgLog = new LinkedList();
            paymentHolder = new ValueHolder();
            try {
                LogicalStorage.get().authorizeAsSystem();
                String command = (String)request.get("command");
                if ("validate".equals(command)) {
                    String pnr = (String)request.get("account");
                    EntityContainer<BookingFile> bfCtr = BRSPGServlet.findBookingFile(pnr, false);
                    if (pnr == null || bfCtr == null) {
                        response = BRSPGServlet.createResponse("0", null, null, null, 5, "Account not found");
                    } else if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.BOOKING || ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.TO_BE_PAYED) {
                        Configuration pgConfig = new Configuration(this.getConnector().getConfiguration());
                        BigDecimal actualPrice = pgConfig.isTest() ? BigDecimal.valueOf(pgConfig.getTestAmount()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)bfCtr.toReference(), (ContractType)ContractType.CLIENT).get(PaymentType.BRS);
                        List<BillingTransactionIndex> transactions = this.getTransactions(bfCtr);
                        BigDecimal sum = BigDecimal.ZERO;
                        for (BillingTransactionIndex tr : transactions) {
                            sum = sum.add(tr.getTransactionSum());
                        }
                        HashMap<String, String> attrs = new HashMap<String, String>();
                        attrs.put("sum", sumF.format(actualPrice.subtract(sum)));
                        response = BRSPGServlet.createResponse("0", attrs, null, null, 0, "OK");
                    } else {
                        response = ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.PAYED || ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.ISSUED ? BRSPGServlet.createResponse("0", null, null, null, 79, "Already paid") : (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.CANCELED ? BRSPGServlet.createResponse("0", null, null, null, 79, "Cancelled") : BRSPGServlet.createResponse("0", null, null, null, 79, "Error"));
                    }
                } else if ("check".equals(command)) {
                    String pnr = (String)request.get("account");
                    EntityContainer<BookingFile> bfCtr = BRSPGServlet.findBookingFile(pnr, false);
                    if (pnr == null || bfCtr == null) {
                        response = BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 5, "Account not found");
                    } else if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.BOOKING || ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.TO_BE_PAYED) {
                        Configuration pgConfig = new Configuration(this.getConnector().getConfiguration());
                        BigDecimal actualPrice = pgConfig.isTest() ? BigDecimal.valueOf(pgConfig.getTestAmount()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)bfCtr.toReference(), (ContractType)ContractType.CLIENT).get(PaymentType.BRS);
                        List<BillingTransactionIndex> transactions = this.getTransactions(bfCtr);
                        BigDecimal sumPaid = BigDecimal.ZERO;
                        for (BillingTransactionIndex tr : transactions) {
                            sumPaid = sumPaid.add(tr.getTransactionSum());
                        }
                        BigDecimal sumToPay = actualPrice.subtract(sumPaid);
                        HashMap<String, String> attrs = new HashMap<String, String>();
                        attrs.put("sum", sumF.format(sumToPay));
                        response = new BigDecimal((String)request.get("sum")).compareTo(sumToPay) > 0 ? BRSPGServlet.createResponse((String)request.get("txn_id"), attrs, null, null, 242, "Sum too large") : BRSPGServlet.createResponse((String)request.get("txn_id"), attrs, null, null, 0, "OK");
                    } else {
                        response = ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.PAYED || ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.ISSUED ? BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 79, "Already paid") : (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.CANCELED ? BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 79, "Cancelled") : BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 79, "Error"));
                    }
                } else if ("pay".equals(command)) {
                    String pnr = (String)request.get("account");
                    EntityContainer<BookingFile> bfCtr = BRSPGServlet.findBookingFile(pnr, false);
                    if (pnr == null || bfCtr == null) {
                        response = BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 5, "Account not found");
                    } else if (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.BOOKING || ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.TO_BE_PAYED) {
                        BillingTransactionIndex bti = this.getTransaction((String)request.get("txn_id"));
                        if (bti != null) {
                            BillingTransaction bt = (BillingTransaction)EntityStorage.get().resolve(bti.getSource()).getEntity();
                            response = BRSPGServlet.createResponse((String)request.get("txn_id"), null, bt.getUid(), bti.getTransactionSum(), 0, "OK");
                        } else {
                            Configuration pgConfig = new Configuration(this.getConnector().getConfiguration());
                            BigDecimal actualPrice = pgConfig.isTest() ? BigDecimal.valueOf(pgConfig.getTestAmount()) : (BigDecimal)PaymentHelper.getTotalPrices((EntityReference)bfCtr.toReference(), (ContractType)ContractType.CLIENT).get(PaymentType.BRS);
                            List<BillingTransactionIndex> transactions = this.getTransactions(bfCtr);
                            BigDecimal sumPaid = BigDecimal.ZERO;
                            for (BillingTransactionIndex tr : transactions) {
                                sumPaid = sumPaid.add(tr.getTransactionSum());
                            }
                            BigDecimal paymentSum = new BigDecimal((String)request.get("sum"));
                            BigDecimal sumToPay = actualPrice.subtract(sumPaid);
                            HashMap<String, String> attrs = new HashMap<String, String>();
                            if (paymentSum.compareTo(sumToPay) > 0) {
                                attrs.put("sum", sumF.format(sumToPay));
                                response = BRSPGServlet.createResponse((String)request.get("txn_id"), attrs, null, null, 242, "Sum too large");
                            } else {
                                EntityContainer btCtr = new EntityContainer(BillingTransaction.class);
                                ((BillingTransaction)btCtr.getEntity()).setAgency(((BookingFile)bfCtr.getEntity()).getAgency());
                                ((BillingTransaction)btCtr.getEntity()).setCategory(BillingTransactionCategory.DEBIT);
                                ((BillingTransaction)btCtr.getEntity()).setEntity(bfCtr.toReference());
                                ((BillingTransaction)btCtr.getEntity()).setDate(new Date());
                                ((BillingTransaction)btCtr.getEntity()).setDescription("");
                                InvoiceTransactionDetails details = new InvoiceTransactionDetails();
                                details.setTransactionCode((String)request.get("txn_id"));
                                ((BillingTransaction)btCtr.getEntity()).setDetails((BaseTransactionDetails)details);
                                ((BillingTransaction)btCtr.getEntity()).setPaymentType(PaymentType.BRS);
                                Money money = new Money();
                                money.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
                                money.setValue(paymentSum);
                                ((BillingTransaction)btCtr.getEntity()).setSum(money);
                                ((BillingTransaction)btCtr.getEntity()).setType(BillingTransactionType.BILLING);
                                EntityStorage.get().save(btCtr, true);
                                if (sumToPay.subtract(paymentSum).compareTo(BigDecimal.ZERO) == 0) {
                                    Payment payment = PaymentHelper.createPayment(bfCtr, (PaymentType)PaymentType.BRS, (ContractType)ContractType.CLIENT);
                                    payment.setBillingTransaction(btCtr.toReference());
                                    this.paymentSucceeded(payment, messages);
                                }
                                attrs.put("sum", sumF.format(sumToPay.subtract(paymentSum)));
                                response = BRSPGServlet.createResponse((String)request.get("txn_id"), attrs, ((BillingTransaction)btCtr.getEntity()).getUid(), paymentSum, 0, "OK");
                            }
                        }
                    } else {
                        response = ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.PAYED || ((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.ISSUED ? BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 79, "Already paid") : (((BookingFile)bfCtr.getEntity()).getWorkflowStatus() == WorkflowStatus.CANCELED ? BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 79, "Cancelled") : BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 79, "Error"));
                    }
                } else if ("paylist".equals(command)) {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)req.getInputStream());
                    Element rollData = (Element)doc.getElementsByTagName("rolldata").item(0);
                    String rollId = rollData.getAttribute("rollid");
                    SimpleDateFormat df = BRSPGServlet.createDf();
                    Date dateFrom = df.parse(rollData.getAttribute("datefrom"));
                    Date dateTo = df.parse(rollData.getAttribute("dateto"));
                    NodeList payments = rollData.getElementsByTagName("payment");
                    Element payListStatusResponse = null;
                    TreeSet<String> processedTransactions = new TreeSet<String>();
                    for (int i = 0; i < payments.getLength(); ++i) {
                        Element payment = (Element)payments.item(i);
                        String txnId = payment.getAttribute("txn_id");
                        Date txnDate = df.parse(payment.getAttribute("txnDate"));
                        String prvTxn = payment.getAttribute("prvTxn");
                        String account = payment.getAttribute("account");
                        BigDecimal sum = new BigDecimal(payment.getAttribute("sum"));
                        BillingTransactionIndex bti = this.getTransaction(txnId);
                        processedTransactions.add(txnId);
                        if (bti != null && bti.getTransactionSum().compareTo(sum) == 0 && bti.getTransactionDate().compareTo(txnDate) == 0 && bti.getTransactionCode().compareTo(prvTxn) == 0) continue;
                        if (payListStatusResponse == null) {
                            payListStatusResponse = BRSPGServlet.createRollDataResponse(rollId, -2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0432\u0435\u0440\u043a\u0435");
                        }
                        BRSPGServlet.addPayment(payListStatusResponse, txnId, txnDate, prvTxn, account, sum, "notexists");
                    }
                    for (BillingTransactionIndex bti : this.getTransactions(dateFrom, dateTo)) {
                        if (processedTransactions.contains(bti.getTransactionCode())) continue;
                        if (payListStatusResponse == null) {
                            payListStatusResponse = BRSPGServlet.createRollDataResponse(rollId, -2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0432\u0435\u0440\u043a\u0435");
                        }
                        BRSPGServlet.addPayment(payListStatusResponse, bti.getTransactionCode(), bti.getTransactionDate(), EntityStorage.get().resolve(bti.getSource()).getUid(), CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)((Reservation)((BookingFile)EntityStorage.get().resolve(bti.getReferencedEntity()).getEntity()).getReservations().get(0))), bti.getTransactionSum(), "notexists");
                    }
                    if (payListStatusResponse == null) {
                        payListStatusResponse = BRSPGServlet.createRollDataResponse(rollId, 0, "\u0421\u0432\u0435\u0440\u0435\u043d \u043e\u0448\u0438\u0431\u043e\u043a \u043d\u0435\u0442");
                    }
                    rollDataResponses.put(rollId, payListStatusResponse);
                    response = BRSPGServlet.createRollDataResponse(rollId, 0, "\u041f\u0440\u0438\u043d\u044f\u0442");
                } else {
                    String txnRollId;
                    response = "payliststatus".equals(command) ? (rollDataResponses.containsKey(txnRollId = (String)request.get("txn_roll_id")) ? rollDataResponses.get(txnRollId) : BRSPGServlet.createRollDataResponse(txnRollId, -1, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")) : BRSPGServlet.createResponse((String)request.get("txn_id"), null, null, null, 300, "Unknown command");
                }
                PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                if (response == null) break block41;
            }
            catch (Throwable t) {
                block42: {
                    try {
                        log.error("service failed", t);
                        response = BRSPGServlet.createResponse(null, null, null, null, 300, t.toString());
                        PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
                        if (response == null) break block42;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            this.sendResponse(res, response);
                        }
                        PGInvocationContext.get().end(this.getConnector(), pgLog);
                        if (paymentHolder.getValue() != null) {
                            PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
                        }
                        LogicalStorage.reset();
                        throw throwable;
                    }
                    this.sendResponse(res, response);
                }
                PGInvocationContext.get().end(this.getConnector(), pgLog);
                if (paymentHolder.getValue() != null) {
                    PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
                }
                LogicalStorage.reset();
            }
            this.sendResponse(res, response);
        }
        PGInvocationContext.get().end(this.getConnector(), pgLog);
        if (paymentHolder.getValue() != null) {
            PGInvocationContext.get().saveDocs(pgLog, messages, ((Payment)paymentHolder.getValue()).getPayee());
        }
        LogicalStorage.reset();
        log.debug("service() END");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpServletResponse res, Element response) throws IOException {
        try {
            XUtil.newTransformer().transform(new DOMSource(response), new StreamResult((OutputStream)res.getOutputStream()));
            res.getOutputStream().flush();
        }
        catch (Exception ex) {
            log.error("error while sending response", (Throwable)ex);
        }
        finally {
            res.getOutputStream().close();
        }
    }

    private static Element createResponse(String osmpTxnId, Map<String, String> attributes, String prvTxn, BigDecimal sum, int result, String comment) {
        Document doc = DocumentBuilderHelper.newDocument();
        Element elm = doc.createElement("response");
        doc.appendChild(elm);
        Element child = doc.createElement("osmp_txn_id");
        child.setTextContent(osmpTxnId);
        elm.appendChild(child);
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attr = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                child = doc.createElement("attribute");
                child.setAttribute("name", attr);
                child.setAttribute("value", value);
                elm.appendChild(child);
            }
        }
        if (prvTxn != null) {
            child = doc.createElement("prv_txn");
            child.setTextContent(prvTxn);
            elm.appendChild(child);
        }
        if (sum != null) {
            child = doc.createElement("sum");
            child.setTextContent(sumF.format(sum));
            elm.appendChild(child);
        }
        child = doc.createElement("result");
        child.setTextContent(Integer.toString(result));
        elm.appendChild(child);
        if (comment != null) {
            child = doc.createElement("comment");
            child.setTextContent(comment);
            elm.appendChild(child);
        }
        return elm;
    }

    private static Element createRollDataResponse(String txnRollId, int result, String comment) {
        Document doc = DocumentBuilderHelper.newDocument();
        Element elm = doc.createElement("rolldata");
        doc.appendChild(elm);
        elm.setAttribute("txn_roll_id", txnRollId);
        Element child = doc.createElement("result");
        child.setTextContent(Integer.toString(result));
        elm.appendChild(child);
        if (comment != null) {
            child = doc.createElement("comment");
            child.setTextContent(comment);
            elm.appendChild(child);
        }
        return elm;
    }

    private static Element addPayment(Element elm, String txnId, Date txnDate, String prvTxn, String account, BigDecimal sum, String error) {
        Element payment = elm.getOwnerDocument().createElement("payment");
        if (txnId != null) {
            payment.setAttribute("txn_id", txnId);
        }
        if (txnDate != null) {
            payment.setAttribute("txn_date", BRSPGServlet.createDf().format(txnDate));
        }
        if (prvTxn != null) {
            payment.setAttribute("prv_txn", prvTxn);
        }
        if (account != null) {
            payment.setAttribute("account", account);
        }
        if (sum != null) {
            payment.setAttribute("sum", sumF.format(sum));
        }
        if (error != null) {
            payment.setAttribute("error", error);
        }
        elm.appendChild(payment);
        return elm;
    }
}

