/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.brs;

import java.util.Properties;

class Configuration {
    private final boolean traceEnabled;
    private final boolean testMode;
    private final Long queuePeriod;
    private final double testAmount;

    Configuration(Properties data) {
        double test;
        this.traceEnabled = Configuration.isTrue(data.getProperty("trace.enabled"));
        this.testMode = Configuration.isTrue(data.getProperty("test.enabled"));
        Long l = this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        if (data.getProperty("test.amount") != null) {
            try {
                test = Double.parseDouble(data.getProperty("test.amount"));
            }
            catch (NumberFormatException e) {
                test = 1000.0;
            }
        } else {
            test = 1000.0;
        }
        this.testAmount = test;
    }

    boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return true;
    }

    double getTestAmount() {
        return this.testAmount;
    }

    boolean isTest() {
        return this.testMode;
    }

    Long getQueuePeriod() {
        return this.queuePeriod;
    }

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }
}

