/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.chronopay;

import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.pg.ChronopayReversalDetails;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGConnectorInfo;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentCheckResult;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGConnectorRegistry;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.chronopay.Configuration;
import com.gridnine.xtrip.server.pg.chronopay.HandlerInitiatePayment;
import com.gridnine.xtrip.server.pg.chronopay.HandlerXmlGateway;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Element;

public class ChronopayPGConnector
extends PGConnector {
    private boolean enabled;
    private boolean disposed;
    private Configuration configuration;
    private Tracer tracer = null;
    private static final String TO_TIMEOUT_TAG_FORMAT = "paymentTimeout.%s";

    public PgName getId() {
        return PgName.CHRONOPAY;
    }

    protected void configure(PGConnectorRegistry registry) {
        super.configure(registry);
        if (!super.isEnabled()) {
            return;
        }
        this.enabled = true;
        this.configuration = new Configuration(this.getConfiguration());
        if (this.configuration.isTraceEnabled()) {
            this.tracer = PGHelper.createTracer((PgName)this.getId());
        }
        this.enabled = this.configuration.isValid();
        if (this.enabled) {
            this.log.debug("configured");
        } else {
            this.log.warn("invalid configuration, CHRONOPAY connector disabled");
        }
    }

    public PGConnectorInfo getConnectorInfo() {
        PGConnectorInfo result = new PGConnectorInfo();
        result.setEnabled(this.isEnabled());
        result.setPg(this.getId());
        result.getSupportedPaymentTypes().add(PaymentType.CREDIT_CARD_ONLINE_CHRONOPAY);
        result.getSupportedPaymentTypes().add(PaymentType.WEBMONEY_CHRONOPAY);
        result.getSupportedPaymentTypes().add(PaymentType.YANDEX_MONEY_CHRONOPAY);
        return result;
    }

    public void dispose() {
        this.disposed = true;
        this.log.debug("disposed");
    }

    protected Long getQueuePeriod() {
        return this.configuration.getQueuePeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentInitiationResult initiatePayment(PaymentInitiationParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        Payment payment = parameters.getPayment();
        this.doPaymentReprice(payment);
        PGInvocationContext.get().begin(InvocationName.INITIATE_PAYMENT.toString());
        Date startDate = new Date();
        PGInvocationContext.get().setPaymentId(payment.getPaymentId());
        PaymentInitiationResult result = new PaymentInitiationResult();
        result.setPayment(payment);
        try {
            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)parameters.getSalesContext(), (PgName)parameters.getPg(), (Payment)payment);
            HandlerInitiatePayment.process(result, parameters, pgParameters, this.configuration);
            this.paymentInitiated(result.getPayment(), result.getMessages());
            result.setSuccess(true);
            result.getMessages().add(MessageHelper.createMessage((String)"\u041f\u043b\u0430\u0442\u0435\u0436 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d", (String)result.getPayment().getPaymentId(), (Object[])new Object[]{PgName.CHRONOPAY}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, null);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (PGException ex) {
            this.log.error("payment initiation failed", (Throwable)ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, (Throwable)ex);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        catch (Throwable t) {
            this.log.error("payment initiation failed", t);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)t));
            result.setSuccess(false);
            result.getPayment().setStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)"\u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0438\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 {0} \u0447\u0435\u0440\u0435\u0437 \u0448\u043b\u044e\u0437 \u043e\u043f\u043b\u0430\u0442\u044b {1} \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", (String)payment.getPaymentId(), (Object[])new Object[]{PgName.CHRONOPAY}));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.INITIATE_PAYMENT.toString(), (Object)parameters, (Object)result, t);
            PaymentInitiationResult paymentInitiationResult = result;
            return paymentInitiationResult;
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentCheckResult checkPayment(PaymentCheckParameters parameters) {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        PGInvocationContext.get().begin(InvocationName.CHECK_PAYMENT.toString());
        Date startDate = new Date();
        PaymentCheckResult result = new PaymentCheckResult();
        try {
            Payment payment = parameters.getPayment();
            PGInvocationContext.get().setPaymentId(payment.getPaymentId());
            PGParameters pgParameters = ChronopayPGConnector.getPgParameters(payment);
            LogicalStorage.get().authorizeAsSystem();
            LinkedList messages = new LinkedList();
            switch (payment.getStatus()) {
                case SUCCEEDED: {
                    this.paymentSucceeded(payment, messages);
                    break;
                }
                case FAILED: {
                    this.paymentFailed(payment, messages);
                }
            }
            boolean twoPhase = pgParameters.getPgAccount().endsWith("*");
            if (twoPhase && payment.getEntity() != null && BookingFile.class.equals((Object)payment.getEntity().getType())) {
                BookingFile bookingFile = (BookingFile)EntityStorage.get().resolve(payment.getEntity()).getEntity();
                boolean allIssued = PaymentHelper.isAllIssued((BookingFile)bookingFile);
                if (allIssued) {
                    this.log.debug("confirm & long record");
                    this.confirmAuth(payment, bookingFile, pgParameters);
                    result.setPaymentStatus(PaymentStatus.SUCCEEDED);
                    result.setSuccess(true);
                } else {
                    this.log.debug("reversal");
                    this.timeoutReversal(payment, pgParameters, (EntityReference<Organization>)parameters.getSalesContext().getAgency(), InvocationName.CHECK_PAYMENT.toString());
                    result.setPaymentStatus(PaymentStatus.FAILED);
                    result.setSuccess(false);
                }
            }
        }
        catch (Throwable ex) {
            this.log.error("payment initiation failed", ex);
            this.log.error("exception body: " + TextUtil.getExceptionStackTrace((Throwable)ex));
            result.setSuccess(false);
            result.setPaymentStatus(PaymentStatus.ERROR);
            result.getMessages().add(MessageHelper.createErrorMessage((String)ex.getMessage(), (Object[])new Object[0]));
            PGInvocationContext.get().addTraceData(startDate, InvocationName.CHECK_PAYMENT.toString(), null, null, ex);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)this, result.getPgLog());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element execute(PGParameters pgParameters, Element request) throws Exception {
        Element response = null;
        HttpURLConnection conn = (HttpURLConnection)new URL(this.configuration.getGatewayUrl()).openConnection();
        try {
            conn.setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            try (OutputStream out = conn.getOutputStream();){
                out.write("request=".getBytes());
                out.write(URLEncoder.encode(XUtil.toString((Element)request), "UTF-8").getBytes());
            }
            try (InputStream in = conn.getInputStream();){
                response = DocumentBuilderHelper.parse((InputStream)in).getDocumentElement();
            }
        }
        finally {
            conn.disconnect();
        }
        return response;
    }

    static void refund(Payment payment) throws Exception {
        HandlerXmlGateway.prepareRequest(2, payment, ChronopayPGConnector.getPgParameters(payment));
    }

    public static PGParameters getPgParameters(Payment payment) throws Exception {
        return PGRulesHelper.getPGParameters((SalesContext)PaymentHelper.restoreSalesContext((Payment)payment), (PgName)PgName.CHRONOPAY, (Payment)payment);
    }

    void timeoutReversal(Payment payment, PGParameters pgParameters, EntityReference<Organization> agencyRef, String transactionName) throws Exception {
        if (this.configuration.isAutoReversalEnabled()) {
            this.addToTimeoutQueue(payment, agencyRef);
            return;
        }
        this.reversal(payment, pgParameters, transactionName);
    }

    void addToTimeoutQueue(Payment payment, EntityReference<Organization> agencyRef) throws Exception {
        try {
            ChronopayReversalDetails details = new ChronopayReversalDetails();
            details.setAgency(agencyRef);
            details.setPayment(payment);
            details.setTimestamp(System.currentTimeMillis());
            TemporalObject to = new TemporalObject();
            Date expiryDate = new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(48L));
            to.setExpired(expiryDate);
            to.setTag("chronopay-reversal");
            to.setData(XSUtil.toString((XSSerializable)details).getBytes());
            LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
        }
        catch (Exception ex) {
            this.log.error(String.format("failed adding payment %s to timeout queue", payment.getPaymentId()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reversal(Payment payment, PGParameters pgParameters, String transactionName) throws Exception {
        Element request = null;
        Element response = null;
        try {
            request = HandlerXmlGateway.prepareRequest(5, payment, ChronopayPGConnector.getPgParameters(payment));
            response = this.execute(pgParameters, request);
            if (response != null) {
                HandlerXmlGateway.processResponse(response);
            }
        }
        finally {
            PGInvocationContext.get().addTraceData(new Date(), transactionName, (Object)request, (Object)response, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void confirmAuth(Payment payment, BookingFile bookingFile, PGParameters pgParameters) throws Exception {
        Element request = null;
        Element response = null;
        try {
            request = HandlerXmlGateway.prepareRequest(6, payment, pgParameters);
            HandlerXmlGateway.injectLongRecord(request, bookingFile);
            response = this.execute(pgParameters, request);
            if (response != null) {
                HandlerXmlGateway.processResponse(response);
            }
        }
        catch (Throwable throwable) {
            PGInvocationContext.get().addTraceData(new Date(), "comfirm", (Object)request, response, null);
            throw throwable;
        }
        PGInvocationContext.get().addTraceData(new Date(), "comfirm", (Object)request, (Object)response, null);
    }
}

